/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"isStringArrayParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "isLoweredSuspendFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "backend.js"})
public final class JsMainFunctionDetectorKt {
    public static final boolean isStringArrayParameter(@NotNull IrValueParameter $this$isStringArrayParameter) {
        Intrinsics.checkNotNullParameter($this$isStringArrayParameter, "<this>");
        IrType irType = $this$isStringArrayParameter.getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType type = irSimpleType;
        if (!IrTypePredicatesKt.isArray(type)) {
            return false;
        }
        if (type.getArguments().size() != 1) {
            return false;
        }
        IrTypeArgument irTypeArgument = CollectionsKt.single(type.getArguments());
        IrTypeProjection irTypeProjection = irTypeArgument instanceof IrTypeProjection ? (IrTypeProjection)irTypeArgument : null;
        if (irTypeProjection == null) {
            return false;
        }
        IrTypeProjection argument = irTypeProjection;
        if (argument.getVariance() == Variance.IN_VARIANCE) {
            return false;
        }
        return IrTypePredicatesKt.isString(argument.getType());
    }

    public static final boolean isLoweredSuspendFunction(@NotNull IrFunction $this$isLoweredSuspendFunction, @NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isLoweredSuspendFunction, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrValueParameter irValueParameter = CollectionsKt.lastOrNull($this$isLoweredSuspendFunction.getParameters());
        if (irValueParameter == null) {
            return false;
        }
        IrValueParameter parameter = irValueParameter;
        IrType irType = parameter.getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType type = irSimpleType;
        return Intrinsics.areEqual(type.getClassifier(), context2.getSymbols().getCoroutineSymbols().getContinuationClass());
    }
}

