/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Objects;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.storage.UserStorageProviderModel;

@ProtoTypeId(value=65540)
public class UserStorageProviderClusterEvent
implements ClusterEvent {
    private boolean removed;
    private String realmId;
    private UserStorageProviderModel storageProvider;

    @ProtoField(value=1)
    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @ProtoField(value=2)
    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    @ProtoField(value=3)
    public UserStorageProviderModel getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProvider(UserStorageProviderModel federationProvider) {
        this.storageProvider = federationProvider;
    }

    public static UserStorageProviderClusterEvent createEvent(boolean removed, String realmId, UserStorageProviderModel provider) {
        UserStorageProviderClusterEvent notification = new UserStorageProviderClusterEvent();
        notification.setRemoved(removed);
        notification.setRealmId(realmId);
        notification.setStorageProvider(provider);
        return notification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserStorageProviderClusterEvent that = (UserStorageProviderClusterEvent)o;
        return this.removed == that.removed && Objects.equals(this.realmId, that.realmId) && Objects.equals(this.storageProvider.getId(), that.storageProvider.getId());
    }

    public int hashCode() {
        return Objects.hash(this.removed, this.realmId, this.storageProvider.getId());
    }
}

