/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.cache;

import io.agroal.api.cache.Acquirable;
import io.agroal.api.cache.ConnectionCache;
import java.util.ArrayDeque;
import java.util.Deque;

public interface LocalConnectionCache {
    public static ConnectionCache single() {
        return new ConnectionCache(){
            private volatile ThreadLocal<Acquirable> threadLocal;
            {
                this.reset();
            }

            @Override
            public Acquirable get() {
                Acquirable acquirable = this.threadLocal.get();
                return acquirable != null && acquirable.acquire() ? acquirable : null;
            }

            @Override
            public void put(Acquirable acquirable) {
                if (acquirable.isAcquirable()) {
                    this.threadLocal.set(acquirable);
                }
            }

            @Override
            public void reset() {
                this.threadLocal = new ThreadLocal();
            }
        };
    }

    public static ConnectionCache fixed(final int size) {
        return new ConnectionCache(){
            private volatile ThreadLocal<Acquirable[]> threadLocal;
            {
                this.reset();
            }

            @Override
            public Acquirable get() {
                Acquirable[] cacheArray = this.threadLocal.get();
                int i = cacheArray.length;
                while (i > 0) {
                    Acquirable element;
                    if ((element = cacheArray[--i]) == null) continue;
                    cacheArray[i] = null;
                    if (!element.acquire()) continue;
                    return element;
                }
                return null;
            }

            @Override
            public void put(Acquirable acquirable) {
                if (acquirable.isAcquirable()) {
                    int last;
                    Acquirable[] cacheArray = this.threadLocal.get();
                    if (cacheArray[last = cacheArray.length - 1] != null) {
                        int i = last;
                        while (--i > 0 && cacheArray[i] != null) {
                        }
                        cacheArray[i < 0 ? last - 1 : i] = cacheArray[last];
                    }
                    cacheArray[last] = acquirable;
                }
            }

            @Override
            public void reset() {
                this.threadLocal = ThreadLocal.withInitial(() -> new Acquirable[size]);
            }
        };
    }

    public static ConnectionCache full() {
        return new ConnectionCache(){
            private volatile ThreadLocal<Deque<Acquirable>> threadLocal;
            {
                this.reset();
            }

            @Override
            public Acquirable get() {
                Deque<Acquirable> queue = this.threadLocal.get();
                for (int i = queue.size(); i > 0; --i) {
                    Acquirable acquirable = queue.removeFirst();
                    if (acquirable.acquire()) {
                        return acquirable;
                    }
                    if (!acquirable.isAcquirable()) continue;
                    queue.addLast(acquirable);
                }
                return null;
            }

            @Override
            public void put(Acquirable acquirable) {
                if (acquirable.acquire()) {
                    this.threadLocal.get().addFirst(acquirable);
                }
            }

            @Override
            public void reset() {
                this.threadLocal = ThreadLocal.withInitial(ArrayDeque::new);
            }
        };
    }
}

