/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife.plaf.basic;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import net.sf.juife.ComponentList;
import net.sf.juife.ComponentListModel;
import net.sf.juife.plaf.ComponentListUI;

public class BasicComponentListUI
extends ComponentListUI {
    private static final String propertyPrefix = "ComponentList.";
    private ComponentList componentList = null;
    private JPanel listPane;
    private final Handler handler = new Handler();

    private BasicComponentListUI() {
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicComponentListUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.componentList = (ComponentList)c;
        this.installDefaults();
        this.installListeners();
    }

    protected void installDefaults() {
        this.listPane = new JPanel();
        this.listPane.setLayout(new BoxLayout(this.listPane, 1));
        this.componentList.add(this.listPane);
        this.loadActionMap();
        this.loadInputMap();
    }

    protected void installListeners() {
        this.componentList.addPropertyChangeListener(this.getHandler());
        this.componentList.addListSelectionListener(this.getHandler());
        this.listPane.addMouseListener(this.getHandler());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
    }

    protected void uninstallDefaults() {
        this.componentList.remove(this.listPane);
        this.componentList = null;
        this.listPane = null;
    }

    protected void uninstallListeners() {
        this.componentList.removePropertyChangeListener(this.getHandler());
        this.componentList.getModel().removeListDataListener(this.getHandler());
        this.componentList.removeListSelectionListener(this.getHandler());
        this.listPane.removeMouseListener(this.getHandler());
    }

    @Override
    public void ensureIndexIsVisible(int index) {
        if (index < 0 || index >= this.componentList.getModel().getSize()) {
            return;
        }
        Object c = this.componentList.getModel().get(index);
        if (c == null) {
            return;
        }
        this.listPane.scrollRectToVisible(((Component)c).getBounds());
    }

    private void loadActionMap() {
        ActionMap map = this.listPane.getActionMap();
        map.put("SelectPreviousComponent", new Actions("SelectPreviousComponent"));
        map.put("SelectNextComponent", new Actions("SelectNextComponent"));
        map.put("ExtendSelectionToPreviousComponent", new Actions("ExtendSelectionToPreviousComponent"));
        map.put("ExtendSelectionToNextComponent", new Actions("ExtendSelectionToNextComponent"));
    }

    private void loadInputMap() {
        InputMap map = this.listPane.getInputMap(1);
        map.put(KeyStroke.getKeyStroke(38, 0), "SelectPreviousComponent");
        map.put(KeyStroke.getKeyStroke(40, 0), "SelectNextComponent");
        map.put(KeyStroke.getKeyStroke(38, 1), "ExtendSelectionToPreviousComponent");
        map.put(KeyStroke.getKeyStroke(40, 1), "ExtendSelectionToNextComponent");
    }

    @Override
    public void updateList() {
        for (Component c : this.listPane.getComponents()) {
            c.removeMouseListener(this.getHandler());
        }
        this.listPane.removeAll();
        for (int i = 0; i < this.componentList.getModel().getSize(); ++i) {
            Object c = this.componentList.getModel().get(i);
            this.listPane.add((Component)c, i);
            ((Component)c).addMouseListener(this.getHandler());
        }
        this.listPane.add(Box.createGlue());
        if (!this.listPane.hasFocus() && this.listPane.isRequestFocusEnabled()) {
            this.listPane.requestFocus();
        }
        this.listPane.revalidate();
        this.listPane.repaint();
    }

    private Handler getHandler() {
        return this.handler;
    }

    @Override
    public void processSelectionEvent(Component c, boolean controlDown, boolean shiftDown) {
        int idx;
        ListSelectionModel sm;
        block19: {
            block21: {
                block20: {
                    block16: {
                        block18: {
                            block17: {
                                sm = this.componentList.getSelectionModel();
                                if (c != null) break block16;
                                if (!this.listPane.hasFocus() && this.listPane.isRequestFocusEnabled()) {
                                    this.listPane.requestFocus();
                                }
                                if (!controlDown && !shiftDown) break block17;
                                if (this.componentList.getSelectionMode() != 0) break block18;
                            }
                            this.componentList.clearSelection();
                        }
                        return;
                    }
                    if (!c.hasFocus()) {
                        c.requestFocus();
                    }
                    idx = -1;
                    for (int i = 0; i < this.componentList.getModel().getSize(); ++i) {
                        if (this.componentList.getModel().get(i) != c) continue;
                        idx = i;
                        break;
                    }
                    if (idx != -1) break block19;
                    if (!controlDown && !shiftDown) break block20;
                    if (this.componentList.getSelectionMode() != 0) break block21;
                }
                this.componentList.clearSelection();
            }
            return;
        }
        int ai = sm.getAnchorSelectionIndex();
        if (!controlDown) {
            if (!shiftDown) {
                this.componentList.setSelectedComponent(c, false);
                return;
            }
            if (ai != -1) {
                sm.setSelectionInterval(ai, idx);
            }
            return;
        }
        if (shiftDown) {
            sm.addSelectionInterval(ai, idx);
        } else if (sm.isSelectedIndex(idx)) {
            sm.removeSelectionInterval(idx, idx);
        } else {
            sm.addSelectionInterval(idx, idx);
        }
    }

    private class Handler
    implements ListDataListener,
    ListSelectionListener,
    PropertyChangeListener,
    MouseListener {
        private Handler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ListSelectionModel m = BasicComponentListUI.this.componentList.getSelectionModel();
            if (m == null) {
                return;
            }
            int min = Math.min(e.getIndex0(), e.getIndex1());
            int max = Math.max(e.getIndex0(), e.getIndex1());
            m.insertIndexInterval(min, max - min + 1, true);
            boolean adjusting = BasicComponentListUI.this.componentList.getModel().getComponentListIsAdjusting();
            if (BasicComponentListUI.this.componentList.getAutoUpdate() && !adjusting) {
                BasicComponentListUI.this.updateList();
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ListSelectionModel m = BasicComponentListUI.this.componentList.getSelectionModel();
            if (m != null) {
                m.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
            boolean adjusting = BasicComponentListUI.this.componentList.getModel().getComponentListIsAdjusting();
            if (BasicComponentListUI.this.componentList.getAutoUpdate() && !adjusting) {
                BasicComponentListUI.this.updateList();
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            boolean adjusting = BasicComponentListUI.this.componentList.getModel().getComponentListIsAdjusting();
            if (BasicComponentListUI.this.componentList.getAutoUpdate() && !adjusting) {
                BasicComponentListUI.this.updateList();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                BasicComponentListUI.this.componentList.fireSelectionProbablyChanged(i);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (e.getPropertyName() == "model") {
                ComponentListModel old1 = (ComponentListModel)e.getOldValue();
                ComponentListModel new1 = (ComponentListModel)e.getNewValue();
                if (old1 != null) {
                    old1.removeListDataListener(BasicComponentListUI.this.getHandler());
                }
                if (new1 != null) {
                    new1.addListDataListener(BasicComponentListUI.this.getHandler());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component c = e.getSource() == BasicComponentListUI.this.listPane ? BasicComponentListUI.this.listPane.getComponentAt(e.getX(), e.getY()) : (Component)e.getSource();
            BasicComponentListUI.this.processSelectionEvent(c, e.isControlDown(), e.isShiftDown());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class Actions
    extends AbstractAction {
        private static final String SELECT_PREV_COMPONENT = "SelectPreviousComponent";
        private static final String SELECT_NEXT_COMPONENT = "SelectNextComponent";
        private static final String SELECT_PREV_COMPONENT_EXTEND = "ExtendSelectionToPreviousComponent";
        private static final String SELECT_NEXT_COMPONENT_EXTEND = "ExtendSelectionToNextComponent";

        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentListModel dm = BasicComponentListUI.this.componentList.getModel();
            ListSelectionModel sm = BasicComponentListUI.this.componentList.getSelectionModel();
            int ai = sm.getAnchorSelectionIndex();
            Object name = this.getValue("Name");
            if (name == SELECT_PREV_COMPONENT) {
                if (sm.isSelectionEmpty()) {
                    return;
                }
                if (ai < 1) {
                    return;
                }
                sm.setSelectionInterval(ai - 1, ai - 1);
            } else if (name == SELECT_NEXT_COMPONENT) {
                if (ai >= dm.getSize() - 1) {
                    return;
                }
                sm.setSelectionInterval(ai + 1, ai + 1);
            } else if (name == SELECT_PREV_COMPONENT_EXTEND) {
                if (sm.isSelectionEmpty()) {
                    return;
                }
                if (ai < 1) {
                    return;
                }
                if (sm.isSelectedIndex(ai - 1)) {
                    sm.removeSelectionInterval(ai, ai);
                    sm.setAnchorSelectionIndex(ai - 1);
                } else {
                    sm.addSelectionInterval(ai - 1, ai - 1);
                }
            } else if (name == SELECT_NEXT_COMPONENT_EXTEND) {
                if (sm.isSelectionEmpty()) {
                    return;
                }
                if (ai >= dm.getSize() - 1) {
                    return;
                }
                if (sm.isSelectedIndex(ai + 1)) {
                    sm.removeSelectionInterval(ai, ai);
                    sm.setAnchorSelectionIndex(ai + 1);
                } else {
                    sm.addSelectionInterval(ai + 1, ai + 1);
                }
            }
        }
    }
}

