/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Base class for inverse Fast Fourier Transform .


This is a base class for the "inverse" or "reverse" Discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child available on the system when the object is
created via the object factory system.

This class transforms a full complex image with Hermitian symmetry
into its real spatial domain representation. If the input does not
have Hermitian symmetry, the imaginary component is discarded.


See:
 ForwardFFTImageFilter , InverseFFTImageFilter

 itk::simple::InverseFFT for the procedural interface

 itk::InverseFFTImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInverseFFTImageFilter.h
*/
public class InverseFFTImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected InverseFFTImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.InverseFFTImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(InverseFFTImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(InverseFFTImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::InverseFFTImageFilter::~InverseFFTImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_InverseFFTImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::InverseFFTImageFilter::InverseFFTImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  InverseFFTImageFilter() {
    this(SimpleITKJNI.new_InverseFFTImageFilter(), true);
  }

  /**
std::string itk::simple::InverseFFTImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.InverseFFTImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::InverseFFTImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.InverseFFTImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::InverseFFTImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.InverseFFTImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
