/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.MathUtil;

public class LimitedPool<T> {
    private final int myMaxCapacity;
    private final ObjectFactory<T> myFactory;
    private Object[] myStorage;
    private int myIndex;

    public LimitedPool(int maxCapacity, @NotNull ObjectFactory<T> factory) {
        if (factory == null) {
            LimitedPool.$$$reportNull$$$0(0);
        }
        this.myStorage = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        this.myMaxCapacity = maxCapacity;
        this.myFactory = factory;
    }

    @NotNull
    public T alloc() {
        if (this.myIndex == 0) {
            T t2 = this.myFactory.create();
            if (t2 == null) {
                LimitedPool.$$$reportNull$$$0(1);
            }
            return t2;
        }
        int i2 = --this.myIndex;
        Object result2 = this.myStorage[i2];
        this.myStorage[i2] = null;
        Object object = result2;
        if (object == null) {
            LimitedPool.$$$reportNull$$$0(2);
        }
        return (T)object;
    }

    public void recycle(@NotNull T t2) {
        if (t2 == null) {
            LimitedPool.$$$reportNull$$$0(3);
        }
        this.myFactory.cleanup(t2);
        if (this.myIndex >= this.myMaxCapacity) {
            return;
        }
        this.ensureCapacity();
        this.myStorage[this.myIndex++] = t2;
    }

    private void ensureCapacity() {
        if (this.myStorage.length <= this.myIndex) {
            int newCapacity = MathUtil.clamp(this.myStorage.length * 3 / 2, 10, this.myMaxCapacity);
            this.myStorage = ArrayUtil.realloc(this.myStorage, newCapacity, ArrayUtil.OBJECT_ARRAY_FACTORY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/LimitedPool";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/LimitedPool";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "alloc";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recycle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ObjectFactory<T> {
        @NotNull
        public T create();

        default public void cleanup(@NotNull T t2) {
            if (t2 == null) {
                ObjectFactory.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/util/containers/LimitedPool$ObjectFactory", "cleanup"));
        }
    }
}

