# F:=Rationals();
local result, l;
result:= rec();
result.comment:=
"A6 as 5 x 5 matrices over Z.\n\
Representation 5b.\n\
Absolutely irreducible representation.\n\
Schur Index 1.\n\
\n\
SEED:\n\
Nonzero v fixed by <x,y^2*x*y> = A5 [L2(5)-type].\n\
v has 1 x 6 = 6 images under G; <v> has 6 images under G.\n\
BASIS:\n\
NSB([x,y,y^2]) with above v.\n\
\n\
Possible matrix entries are in {-1,0,1}.\n\
\n\
Average number of nonzero entries for any element of the group:\n\
8 + 1/3  (about 8.333; 33.333%).\n\
\n\
Entry  Av/Mat           %Av/Mat\n\
    0  16.667 [16+2/3]   66.667 [66+2/3]\n\
   1   8.333  [8+1/3]   33.333 [33+1/3]\n\
    1   4.167  [4+1/6]   16.667 [16+2/3]\n\
   -1   4.167  [4+1/6]   16.667 [16+2/3]\n\
";
result.symmetricforms:= [];
result.antisymmetricforms:= [];
result.hermitianforms:= [];
result.centralizeralgebra:= [];
result.generators:= List( [ [
1,0,0,0,0,
0,0,0,1,0,
0,0,0,0,1,
0,1,0,0,0,
0,0,1,0,0]
,[
0,1,0,0,0,
0,0,1,0,0,
0,0,0,0,1,
-1,-1,-1,-1,-1,
1,0,0,0,0]
], l -> List( [ 0 .. 4 ],
i -> l{ [ i*5+1 .. (i+1)*5 ] } ) );


l:= [
5,-1,-1,-1,-1,
-1,5,-1,-1,-1,
-1,-1,5,-1,-1,
-1,-1,-1,5,-1,
-1,-1,-1,-1,5];
Add( result.symmetricforms, List( [ 0 .. 4 ],
i -> l{ [ i*5+1 .. (i+1)*5 ] } ) );


Add( result.centralizeralgebra, IdentityMat(5) );
return result;
