﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/network-firewall/NetworkFirewall_EXPORTS.h>
#include <aws/network-firewall/model/FirewallPolicy.h>
#include <aws/network-firewall/model/FirewallPolicyResponse.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace NetworkFirewall {
namespace Model {
class DescribeFirewallPolicyResult {
 public:
  AWS_NETWORKFIREWALL_API DescribeFirewallPolicyResult() = default;
  AWS_NETWORKFIREWALL_API DescribeFirewallPolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NETWORKFIREWALL_API DescribeFirewallPolicyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A token used for optimistic locking. Network Firewall returns a token to your
   * requests that access the firewall policy. The token marks the state of the
   * policy resource at the time of the request. </p> <p>To make changes to the
   * policy, you provide the token in your request. Network Firewall uses the token
   * to ensure that the policy hasn't changed since you last retrieved it. If it has
   * changed, the operation fails with an <code>InvalidTokenException</code>. If this
   * happens, retrieve the firewall policy again to get a current copy of it with
   * current token. Reapply your changes as needed, then try the operation again
   * using the new token. </p>
   */
  inline const Aws::String& GetUpdateToken() const { return m_updateToken; }
  template <typename UpdateTokenT = Aws::String>
  void SetUpdateToken(UpdateTokenT&& value) {
    m_updateTokenHasBeenSet = true;
    m_updateToken = std::forward<UpdateTokenT>(value);
  }
  template <typename UpdateTokenT = Aws::String>
  DescribeFirewallPolicyResult& WithUpdateToken(UpdateTokenT&& value) {
    SetUpdateToken(std::forward<UpdateTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The high-level properties of a firewall policy. This, along with the
   * <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a
   * firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>
   */
  inline const FirewallPolicyResponse& GetFirewallPolicyResponse() const { return m_firewallPolicyResponse; }
  template <typename FirewallPolicyResponseT = FirewallPolicyResponse>
  void SetFirewallPolicyResponse(FirewallPolicyResponseT&& value) {
    m_firewallPolicyResponseHasBeenSet = true;
    m_firewallPolicyResponse = std::forward<FirewallPolicyResponseT>(value);
  }
  template <typename FirewallPolicyResponseT = FirewallPolicyResponse>
  DescribeFirewallPolicyResult& WithFirewallPolicyResponse(FirewallPolicyResponseT&& value) {
    SetFirewallPolicyResponse(std::forward<FirewallPolicyResponseT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The policy for the specified firewall policy. </p>
   */
  inline const FirewallPolicy& GetFirewallPolicy() const { return m_firewallPolicy; }
  template <typename FirewallPolicyT = FirewallPolicy>
  void SetFirewallPolicy(FirewallPolicyT&& value) {
    m_firewallPolicyHasBeenSet = true;
    m_firewallPolicy = std::forward<FirewallPolicyT>(value);
  }
  template <typename FirewallPolicyT = FirewallPolicy>
  DescribeFirewallPolicyResult& WithFirewallPolicy(FirewallPolicyT&& value) {
    SetFirewallPolicy(std::forward<FirewallPolicyT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeFirewallPolicyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_updateToken;

  FirewallPolicyResponse m_firewallPolicyResponse;

  FirewallPolicy m_firewallPolicy;

  Aws::String m_requestId;
  bool m_updateTokenHasBeenSet = false;
  bool m_firewallPolicyResponseHasBeenSet = false;
  bool m_firewallPolicyHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace NetworkFirewall
}  // namespace Aws
