/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.DataSender;

public abstract class AbstractSender
implements DataSender {
    private volatile boolean connected = false;
    private int rxBufSize = 25188;
    private int txBufSize = 65536;
    private int udpRxBufSize = 25188;
    private int udpTxBufSize = 65536;
    private boolean directBuffer = false;
    private int keepAliveCount = -1;
    private int requestCount = 0;
    private long connectTime;
    private long keepAliveTime = -1L;
    private long timeout = 3000L;
    private Member destination;
    private InetAddress address;
    private int port;
    private int maxRetryAttempts = 1;
    private int attempt;
    private boolean tcpNoDelay = true;
    private boolean soKeepAlive = false;
    private boolean ooBInline = true;
    private boolean soReuseAddress = true;
    private boolean soLingerOn = false;
    private int soLingerTime = 3;
    private int soTrafficClass = 28;
    private boolean throwOnFailedAck = true;
    private boolean udpBased = false;
    private int udpPort = -1;

    public static void transferProperties(AbstractSender abstractSender, AbstractSender abstractSender2) {
        abstractSender2.rxBufSize = abstractSender.rxBufSize;
        abstractSender2.txBufSize = abstractSender.txBufSize;
        abstractSender2.directBuffer = abstractSender.directBuffer;
        abstractSender2.keepAliveCount = abstractSender.keepAliveCount;
        abstractSender2.keepAliveTime = abstractSender.keepAliveTime;
        abstractSender2.timeout = abstractSender.timeout;
        abstractSender2.destination = abstractSender.destination;
        abstractSender2.address = abstractSender.address;
        abstractSender2.port = abstractSender.port;
        abstractSender2.maxRetryAttempts = abstractSender.maxRetryAttempts;
        abstractSender2.tcpNoDelay = abstractSender.tcpNoDelay;
        abstractSender2.soKeepAlive = abstractSender.soKeepAlive;
        abstractSender2.ooBInline = abstractSender.ooBInline;
        abstractSender2.soReuseAddress = abstractSender.soReuseAddress;
        abstractSender2.soLingerOn = abstractSender.soLingerOn;
        abstractSender2.soLingerTime = abstractSender.soLingerTime;
        abstractSender2.soTrafficClass = abstractSender.soTrafficClass;
        abstractSender2.throwOnFailedAck = abstractSender.throwOnFailedAck;
        abstractSender2.udpBased = abstractSender.udpBased;
        abstractSender2.udpPort = abstractSender.udpPort;
    }

    @Override
    public boolean keepalive() {
        boolean bl = false;
        if (this.isUdpBased()) {
            bl = true;
        } else if (this.keepAliveCount >= 0 && this.requestCount > this.keepAliveCount) {
            bl = true;
        } else if (this.keepAliveTime >= 0L && System.currentTimeMillis() - this.connectTime > this.keepAliveTime) {
            bl = true;
        }
        if (bl) {
            this.disconnect();
        }
        return bl;
    }

    protected void setConnected(boolean bl) {
        this.connected = bl;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    public Member getDestination() {
        return this.destination;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @Override
    public int getRequestCount() {
        return this.requestCount;
    }

    public int getRxBufSize() {
        return this.rxBufSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getTxBufSize() {
        return this.txBufSize;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setDirectBuffer(boolean bl) {
        this.directBuffer = bl;
    }

    public boolean getDirectBuffer() {
        return this.directBuffer;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean getSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean getOoBInline() {
        return this.ooBInline;
    }

    public boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    public boolean getSoLingerOn() {
        return this.soLingerOn;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public int getSoTrafficClass() {
        return this.soTrafficClass;
    }

    public boolean getThrowOnFailedAck() {
        return this.throwOnFailedAck;
    }

    @Override
    public void setKeepAliveCount(int n) {
        this.keepAliveCount = n;
    }

    @Override
    public void setKeepAliveTime(long l) {
        this.keepAliveTime = l;
    }

    public void setRequestCount(int n) {
        this.requestCount = n;
    }

    @Override
    public void setRxBufSize(int n) {
        this.rxBufSize = n;
    }

    @Override
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Override
    public void setTxBufSize(int n) {
        this.txBufSize = n;
    }

    public void setConnectTime(long l) {
        this.connectTime = l;
    }

    public void setMaxRetryAttempts(int n) {
        this.maxRetryAttempts = n;
    }

    public void setAttempt(int n) {
        this.attempt = n;
    }

    public void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    public void setSoKeepAlive(boolean bl) {
        this.soKeepAlive = bl;
    }

    public void setOoBInline(boolean bl) {
        this.ooBInline = bl;
    }

    public void setSoReuseAddress(boolean bl) {
        this.soReuseAddress = bl;
    }

    public void setSoLingerOn(boolean bl) {
        this.soLingerOn = bl;
    }

    public void setSoLingerTime(int n) {
        this.soLingerTime = n;
    }

    public void setSoTrafficClass(int n) {
        this.soTrafficClass = n;
    }

    public void setThrowOnFailedAck(boolean bl) {
        this.throwOnFailedAck = bl;
    }

    public void setDestination(Member member) throws UnknownHostException {
        this.destination = member;
        this.address = InetAddress.getByAddress(member.getHost());
        this.port = member.getPort();
        this.udpPort = member.getUdpPort();
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public boolean isUdpBased() {
        return this.udpBased;
    }

    public void setUdpBased(boolean bl) {
        this.udpBased = bl;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public void setUdpPort(int n) {
        this.udpPort = n;
    }

    public int getUdpRxBufSize() {
        return this.udpRxBufSize;
    }

    public void setUdpRxBufSize(int n) {
        this.udpRxBufSize = n;
    }

    public int getUdpTxBufSize() {
        return this.udpTxBufSize;
    }

    public void setUdpTxBufSize(int n) {
        this.udpTxBufSize = n;
    }
}

