/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.FixedCHARCopyingBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

class FixedCHARBinder
extends Binder {
    private static final String CLASS_NAME = FixedCHARBinder.class.getName();
    String paramVal;
    Binder theFixedCHARCopyingBinder = null;

    static void init(Binder x) {
        x.type = (short)96;
        x.bytelen = 0;
    }

    FixedCHARBinder(String val) {
        FixedCHARBinder.init(this);
        this.paramVal = val;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        String value = this.paramVal;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            bindIndicators[indoffset] = 0;
            int length = value.length();
            if (bindUseDBA) {
                long pos;
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                CharacterSet targetCS = stmt.getCharacterSetForBind(bindPosition, (short)formOfUse);
                int convertedBytesLengthActual = targetCS.getOracleId() == 1 && !stmt.connection.isStrictAsciiConversion ? bindData.putAsciiString(value) : bindData.putStringWithReplacement(value, targetCS);
                bindDataLengths[bindDataIndex] = convertedBytesLengthActual;
                stmt.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "bind", "lastBoundDataLengths={0}. ", (String)null, (Throwable)null, (Object)convertedBytesLengthActual);
                stmt.lastBoundDataLengths[bindPosition] = convertedBytesLengthActual;
            } else {
                value.getChars(0, length, bindChars, charoffset);
            }
            if ((length <<= 1) > 65534) {
                length = 65534;
            }
            bindIndicators[lenoffset] = (short)length;
        }
        return localCheckSum;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        String value = this.paramVal;
        CharacterSet targetCS = stmt.getCharacterSetForBind(bindPosition, (short)formOfUse);
        if (targetCS.getOracleId() == 1 && !stmt.connection.isStrictAsciiConversion) {
            String asciiString = value;
            if (asciiString == null || asciiString.length() == 0) {
                return null;
            }
            int length = asciiString.length();
            byte[] asciiBytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                asciiBytes[i] = (byte)asciiString.charAt(i);
            }
            return SQLUtil.makeDatum((OracleConnection)stmt.connection, asciiBytes, internalType, null, 0);
        }
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, targetCS.convertWithReplacement(value), internalType, null, 0);
    }

    @Override
    Binder copyingBinder() {
        if (this.theFixedCHARCopyingBinder == null) {
            this.theFixedCHARCopyingBinder = new FixedCHARCopyingBinder(this.paramVal);
        }
        return this.theFixedCHARCopyingBinder;
    }
}

