/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.directwebremoting.util.LocalUtil;

public class VersionUtil {
    private static boolean loaded = false;
    private static final String VERSION_FILE_PATH = "/dwr-version.properties";
    private static final String KEY_MAJOR = "major";
    private static int major;
    private static final String KEY_MINOR = "minor";
    private static int minor;
    private static final String KEY_REVISION = "revision";
    private static int revision;
    private static final String KEY_BUILD = "bamboo.build.number";
    private static int build;
    private static final String KEY_TITLE = "title";
    private static String title;
    private static String label;

    @Deprecated
    public static String getVersion() {
        return VersionUtil.getLabel();
    }

    public static int getMajor() {
        return major;
    }

    public static int getMinor() {
        return minor;
    }

    public static int getRevision() {
        return revision;
    }

    public static int getBuild() {
        return build;
    }

    public static String getTitle() {
        VersionUtil.loadProperties();
        return title;
    }

    public static String getLabel() {
        VersionUtil.loadProperties();
        return label;
    }

    private static synchronized void loadProperties() {
        if (loaded) {
            return;
        }
        try {
            InputStream in = LocalUtil.getInternalResourceAsStream(VERSION_FILE_PATH);
            Properties props = new Properties();
            props.load(in);
            major = Integer.parseInt(props.getProperty(KEY_MAJOR));
            minor = Integer.parseInt(props.getProperty(KEY_MINOR));
            revision = Integer.parseInt(props.getProperty(KEY_REVISION));
            String buildString = props.getProperty(KEY_BUILD);
            if (null != buildString && buildString.length() > 0) {
                build = Integer.parseInt(props.getProperty(KEY_BUILD));
            }
            label = (title = props.getProperty(KEY_TITLE)).length() == 0 ? major + "." + minor + "." + revision : (build > -1 ? major + "." + minor + "." + revision + "-" + title + "-" + build : major + "." + minor + "." + revision + "-" + title);
            loaded = true;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        build = -1;
    }
}

