/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.ArrayMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0010\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0096\u0082\u0004R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/util/OneElementArrayMap;", "T", "", "Lorg/jetbrains/kotlin/util/ArrayMap;", "value", "index", "", "<init>", "(Ljava/lang/Object;I)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getIndex", "()I", "size", "getSize", "set", "", "(ILjava/lang/Object;)V", "get", "(I)Ljava/lang/Object;", "copy", "iterator", "", "compiler.common"})
public final class OneElementArrayMap<T>
extends ArrayMap<T> {
    @NotNull
    private final T value;
    private final int index;

    public OneElementArrayMap(@NotNull T value2, int index) {
        Intrinsics.checkNotNullParameter(value2, "value");
        super(null);
        this.value = value2;
        this.index = index;
    }

    @NotNull
    public final T getValue() {
        return this.value;
    }

    public final int getIndex() {
        return this.index;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public void set(int index, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    public T get(int index) {
        return index == this.index ? (T)this.value : null;
    }

    @Override
    @NotNull
    public ArrayMap<T> copy() {
        return new OneElementArrayMap<T>(this.value, this.index);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private boolean notVisited;
            final /* synthetic */ OneElementArrayMap<T> this$0;
            {
                this.this$0 = $receiver;
                this.notVisited = true;
            }

            public boolean hasNext() {
                return this.notVisited;
            }

            public T next() {
                if (this.notVisited) {
                    this.notVisited = false;
                    return this.this$0.getValue();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }
}

