/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.spi;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.DialectOverride;
import org.hibernate.boot.models.annotations.spi.DialectOverrider;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ModelsContext;

public abstract class AbstractOverrider<O extends Annotation>
implements DialectOverrider<O> {
    private Class<? extends Dialect> dialect;
    private DialectOverride.Version before;
    private DialectOverride.Version sameOrAfter;

    public AbstractOverrider() {
    }

    public AbstractOverrider(Map<String, Object> attributeValues, AnnotationDescriptor<?> descriptor, ModelsContext modelContext) {
        this.dialect((Class)attributeValues.get("dialect"));
        this.before((DialectOverride.Version)attributeValues.get("before"));
        this.sameOrAfter((DialectOverride.Version)attributeValues.get("sameOrAfter"));
    }

    @Override
    public Class<? extends Dialect> dialect() {
        return this.dialect;
    }

    public void dialect(Class<? extends Dialect> dialect) {
        this.dialect = dialect;
    }

    @Override
    public DialectOverride.Version before() {
        return this.before;
    }

    public void before(DialectOverride.Version before) {
        this.before = before;
    }

    @Override
    public DialectOverride.Version sameOrAfter() {
        return this.sameOrAfter;
    }

    public void sameOrAfter(DialectOverride.Version sameOrAfter) {
        this.sameOrAfter = sameOrAfter;
    }

    @Override
    public boolean matches(Dialect dialectToMatch) {
        if (!this.dialect().isAssignableFrom(dialectToMatch.getClass())) {
            return false;
        }
        DatabaseVersion versionToMatch = dialectToMatch.getVersion();
        return versionToMatch.isBefore(this.before().major(), this.before().minor()) && versionToMatch.isSameOrAfter(this.sameOrAfter().major(), this.sameOrAfter().minor());
    }
}

