/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayAndElementArgumentTypeResolver;
import org.hibernate.dialect.function.array.ArrayAndElementArgumentValidator;
import org.hibernate.dialect.function.array.ArrayViaArgumentReturnTypeResolver;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class GaussDBArraySetFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public GaussDBArraySetFunction() {
        super("array_set", StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{new ArrayAndElementArgumentValidator(0, new int[]{2}), new ArgumentTypesValidator(null, new FunctionParameterType[]{FunctionParameterType.ANY, FunctionParameterType.INTEGER, FunctionParameterType.ANY})}), ArrayViaArgumentReturnTypeResolver.DEFAULT_INSTANCE, StandardFunctionArgumentTypeResolvers.composite((FunctionArgumentTypeResolver[])new FunctionArgumentTypeResolver[]{StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE, StandardFunctionArgumentTypeResolvers.invariant((FunctionParameterType[])new FunctionParameterType[]{FunctionParameterType.ANY, FunctionParameterType.INTEGER, FunctionParameterType.ANY}), new ArrayAndElementArgumentTypeResolver(0, new int[]{2})}));
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression indexExpression = (Expression)sqlAstArguments.get(1);
        Expression elementExpression = (Expression)sqlAstArguments.get(2);
        sqlAppender.append((CharSequence)"( SELECT array_agg( CASE WHEN idx_gen = ");
        indexExpression.accept(walker);
        sqlAppender.append((CharSequence)" THEN ");
        elementExpression.accept(walker);
        sqlAppender.append((CharSequence)" ELSE CASE  WHEN idx_gen <= array_length(ewa1_0.the_array, 1) ");
        sqlAppender.append((CharSequence)" THEN ewa1_0.the_array[idx_gen] ELSE NULL END END ORDER BY idx_gen ) ");
        sqlAppender.append((CharSequence)" FROM generate_series(1, GREATEST(COALESCE(array_length( ");
        arrayExpression.accept(walker);
        sqlAppender.append((CharSequence)" , 1), 0),  ");
        indexExpression.accept(walker);
        sqlAppender.append((CharSequence)" )) AS idx_gen ) AS result_array ");
    }
}

