/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jzlib;

import com.jcraft.jsch.jzlib.Deflate;
import com.jcraft.jsch.jzlib.GZIPException;
import com.jcraft.jsch.jzlib.JZlib;
import com.jcraft.jsch.jzlib.ZStream;

final class Deflater
extends ZStream {
    private static final int MAX_WBITS = 15;
    private static final int DEF_WBITS = 15;
    private static final int Z_NO_FLUSH = 0;
    private static final int Z_PARTIAL_FLUSH = 1;
    private static final int Z_SYNC_FLUSH = 2;
    private static final int Z_FULL_FLUSH = 3;
    private static final int Z_FINISH = 4;
    private static final int MAX_MEM_LEVEL = 9;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private boolean finished = false;

    Deflater() {
    }

    Deflater(int level) throws GZIPException {
        this(level, 15);
    }

    Deflater(int level, boolean nowrap) throws GZIPException {
        this(level, 15, nowrap);
    }

    Deflater(int level, int bits) throws GZIPException {
        this(level, bits, false);
    }

    Deflater(int level, int bits, boolean nowrap) throws GZIPException {
        int ret = this.init(level, bits, nowrap);
        if (ret != 0) {
            throw new GZIPException(ret + ": " + this.msg);
        }
    }

    Deflater(int level, int bits, int memlevel, JZlib.WrapperType wrapperType) throws GZIPException {
        int ret = this.init(level, bits, memlevel, wrapperType);
        if (ret != 0) {
            throw new GZIPException(ret + ": " + this.msg);
        }
    }

    Deflater(int level, int bits, int memlevel) throws GZIPException {
        int ret = this.init(level, bits, memlevel);
        if (ret != 0) {
            throw new GZIPException(ret + ": " + this.msg);
        }
    }

    int init(int level) {
        return this.init(level, 15);
    }

    int init(int level, boolean nowrap) {
        return this.init(level, 15, nowrap);
    }

    int init(int level, int bits) {
        return this.init(level, bits, false);
    }

    int init(int level, int bits, int memlevel, JZlib.WrapperType wrapperType) {
        if (bits < 9 || bits > 15) {
            return -2;
        }
        if (wrapperType == JZlib.W_NONE) {
            bits *= -1;
        } else if (wrapperType == JZlib.W_GZIP) {
            bits += 16;
        } else {
            if (wrapperType == JZlib.W_ANY) {
                return -2;
            }
            if (wrapperType == JZlib.W_ZLIB) {
                // empty if block
            }
        }
        return this.init(level, bits, memlevel);
    }

    int init(int level, int bits, int memlevel) {
        this.finished = false;
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, bits, memlevel);
    }

    int init(int level, int bits, boolean nowrap) {
        this.finished = false;
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, nowrap ? -bits : bits);
    }

    @Override
    int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflate(flush);
        if (ret == 1) {
            this.finished = true;
        }
        return ret;
    }

    @Override
    int end() {
        this.finished = true;
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflateEnd();
        this.dstate = null;
        this.free();
        return ret;
    }

    int params(int level, int strategy) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateParams(level, strategy);
    }

    int setDictionary(byte[] dictionary, int dictLength) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateSetDictionary(dictionary, dictLength);
    }

    @Override
    boolean finished() {
        return this.finished;
    }

    int copy(Deflater src) {
        this.finished = src.finished;
        return Deflate.deflateCopy(this, src);
    }
}

