/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.nio.file.Path;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.app.DBPProject;

class DataSourceFileStorage
implements DBPDataSourceConfigurationStorage {
    private Path sourceFile;
    private boolean isLegacy;
    private boolean isDefault;
    private String configSuffix;

    DataSourceFileStorage(Path sourceFile, boolean isLegacy, boolean isDefault) {
        this.sourceFile = sourceFile;
        this.isLegacy = isLegacy;
        this.isDefault = isDefault;
        if (isDefault) {
            this.configSuffix = "";
        } else {
            String configFileName = sourceFile.getFileName().toString();
            this.configSuffix = configFileName.substring("data-sources".length(), configFileName.length() - ".json".length());
        }
    }

    public String getStorageId() {
        return "file://" + String.valueOf(this.sourceFile.toAbsolutePath());
    }

    public String getStorageName() {
        return this.sourceFile.getFileName().toString();
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public boolean isValid() {
        return true;
    }

    public String getStatus() {
        return "Valid";
    }

    public String getName() {
        return this.sourceFile.getFileName().toString();
    }

    public String getStorageSubId() {
        return this.configSuffix;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isVirtual() {
        return false;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    void convertToModern(DBPProject project) {
        this.sourceFile = project.getMetadataFolder(true).resolve("data-sources.json");
        this.isLegacy = false;
    }

    public boolean equals(Object obj) {
        return obj instanceof DataSourceFileStorage && this.sourceFile.equals(((DataSourceFileStorage)obj).sourceFile);
    }

    public int hashCode() {
        return this.sourceFile.hashCode();
    }

    public String toString() {
        return this.sourceFile.toAbsolutePath().toString();
    }
}

