﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/forecast/ForecastService_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {
class CreateWhatIfAnalysisResult {
 public:
  AWS_FORECASTSERVICE_API CreateWhatIfAnalysisResult() = default;
  AWS_FORECASTSERVICE_API CreateWhatIfAnalysisResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FORECASTSERVICE_API CreateWhatIfAnalysisResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the what-if analysis.</p>
   */
  inline const Aws::String& GetWhatIfAnalysisArn() const { return m_whatIfAnalysisArn; }
  template <typename WhatIfAnalysisArnT = Aws::String>
  void SetWhatIfAnalysisArn(WhatIfAnalysisArnT&& value) {
    m_whatIfAnalysisArnHasBeenSet = true;
    m_whatIfAnalysisArn = std::forward<WhatIfAnalysisArnT>(value);
  }
  template <typename WhatIfAnalysisArnT = Aws::String>
  CreateWhatIfAnalysisResult& WithWhatIfAnalysisArn(WhatIfAnalysisArnT&& value) {
    SetWhatIfAnalysisArn(std::forward<WhatIfAnalysisArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateWhatIfAnalysisResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_whatIfAnalysisArn;
  bool m_whatIfAnalysisArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
