"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.composeSpan = exports.composeAggregations = void 0;
var _explorer = require("../../../common/constants/explorer");
var _utils = require("../../../common/utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const composeAggregations = (aggConfig, staleStats) => {
  var _staleStats$partition, _staleStats$all_num, _staleStats$delim, _staleStats$dedup_spl;
  return {
    aggregations: aggConfig.series.map(metric => ({
      function_alias: metric[_explorer.CUSTOM_LABEL],
      function: {
        name: metric.aggregation,
        value_expression: metric.name,
        percentile_agg_function: ''
      }
    })),
    groupby: {
      group_fields: [...(aggConfig.dimensions || []), ...(aggConfig.breakdowns || [])].map(dimension => ({
        name: `\`${(0, _utils.removeBacktick)(dimension.name)}\``
      })),
      ...(aggConfig.span && JSON.stringify(aggConfig === null || aggConfig === void 0 ? void 0 : aggConfig.span) !== '{}' && {
        span: composeSpan(aggConfig.span)
      })
    },
    partitions: (_staleStats$partition = staleStats === null || staleStats === void 0 ? void 0 : staleStats.partitions) !== null && _staleStats$partition !== void 0 ? _staleStats$partition : {},
    all_num: (_staleStats$all_num = staleStats === null || staleStats === void 0 ? void 0 : staleStats.all_num) !== null && _staleStats$all_num !== void 0 ? _staleStats$all_num : {},
    delim: (_staleStats$delim = staleStats === null || staleStats === void 0 ? void 0 : staleStats.delim) !== null && _staleStats$delim !== void 0 ? _staleStats$delim : {},
    dedup_split_value: (_staleStats$dedup_spl = staleStats === null || staleStats === void 0 ? void 0 : staleStats.dedup_split_value) !== null && _staleStats$dedup_spl !== void 0 ? _staleStats$dedup_spl : {}
  };
};
exports.composeAggregations = composeAggregations;
const composeSpan = spanConfig => {
  var _spanConfig$CUSTOM_LA, _spanConfig$time_fiel, _spanConfig$time_fiel2, _spanConfig$time_fiel3, _spanConfig$time_fiel4, _spanConfig$unit$0$va, _spanConfig$unit$, _spanConfig$interval;
  return {
    [_explorer.CUSTOM_LABEL]: (_spanConfig$CUSTOM_LA = spanConfig[_explorer.CUSTOM_LABEL]) !== null && _spanConfig$CUSTOM_LA !== void 0 ? _spanConfig$CUSTOM_LA : '',
    span_expression: {
      type: (_spanConfig$time_fiel = (_spanConfig$time_fiel2 = spanConfig.time_field[0]) === null || _spanConfig$time_fiel2 === void 0 ? void 0 : _spanConfig$time_fiel2.type) !== null && _spanConfig$time_fiel !== void 0 ? _spanConfig$time_fiel : 'timestamp',
      field: (_spanConfig$time_fiel3 = (_spanConfig$time_fiel4 = spanConfig.time_field[0]) === null || _spanConfig$time_fiel4 === void 0 ? void 0 : _spanConfig$time_fiel4.name) !== null && _spanConfig$time_fiel3 !== void 0 ? _spanConfig$time_fiel3 : 'timestamp',
      time_unit: (_spanConfig$unit$0$va = (_spanConfig$unit$ = spanConfig.unit[0]) === null || _spanConfig$unit$ === void 0 ? void 0 : _spanConfig$unit$.value) !== null && _spanConfig$unit$0$va !== void 0 ? _spanConfig$unit$0$va : 'd',
      literal_value: (_spanConfig$interval = spanConfig.interval) !== null && _spanConfig$interval !== void 0 ? _spanConfig$interval : 1
    }
  };
};
exports.composeSpan = composeSpan;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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