/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

public class CopyState
implements Closeable {
    private final GatedCloseable<SegmentInfos> segmentInfosRef;
    private final ReplicationCheckpoint replicationCheckpoint;
    private final byte[] infosBytes;
    private final IndexShard shard;

    public CopyState(IndexShard shard) throws IOException {
        this.shard = shard;
        long lastRefreshedCheckpoint = shard.getLastRefreshedCheckpoint();
        Tuple<GatedCloseable<SegmentInfos>, ReplicationCheckpoint> latestSegmentInfosAndCheckpoint = shard.getLatestSegmentInfosAndCheckpoint();
        this.segmentInfosRef = (GatedCloseable)latestSegmentInfosAndCheckpoint.v1();
        this.replicationCheckpoint = (ReplicationCheckpoint)latestSegmentInfosAndCheckpoint.v2();
        SegmentInfos segmentInfos = this.segmentInfosRef.get();
        SegmentInfos segmentInfosSnapshot = segmentInfos.clone();
        Map userData = segmentInfosSnapshot.getUserData();
        long maxSeqNo = Long.parseLong(userData.getOrDefault("max_seq_no", "-1"));
        userData.put("max_seq_no", Long.toString(Math.min(maxSeqNo, lastRefreshedCheckpoint)));
        segmentInfosSnapshot.setUserData(userData, false);
        ByteBuffersDataOutput buffer = new ByteBuffersDataOutput();
        try (ByteBuffersIndexOutput indexOutput = new ByteBuffersIndexOutput(buffer, "", null);){
            segmentInfosSnapshot.write((IndexOutput)indexOutput);
        }
        this.infosBytes = buffer.toArrayCopy();
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.replicationCheckpoint;
    }

    public Map<String, StoreFileMetadata> getMetadataMap() {
        return this.replicationCheckpoint.getMetadataMap();
    }

    public byte[] getInfosBytes() {
        return this.infosBytes;
    }

    public IndexShard getShard() {
        return this.shard;
    }

    @Override
    public void close() throws IOException {
        try {
            this.segmentInfosRef.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

