/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.request.RequestHandlerExecutor;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPageFactory
implements IPageFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageFactory.class);
    private final ConcurrentMap<Class<?>, Constructor<?>> constructorForClass = Generics.newConcurrentHashMap();
    private final ConcurrentMap<String, Boolean> pageToBookmarkableCache = Generics.newConcurrentHashMap();

    @Override
    public final <C extends IRequestablePage> C newPage(Class<C> pageClass) {
        try {
            Constructor<C> constructor = pageClass.getDeclaredConstructor(null);
            return this.processPage(this.newPage(constructor, null), (PageParameters)null);
        }
        catch (NoSuchMethodException e) {
            Constructor<C> constructor = this.constructor(pageClass, PageParameters.class);
            if (constructor != null) {
                PageParameters pp = new PageParameters();
                return this.processPage(this.newPage(constructor, pp), pp);
            }
            throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does not have a visible default constructor.", e);
        }
    }

    @Override
    public final <C extends IRequestablePage> C newPage(Class<C> pageClass, PageParameters parameters) {
        Constructor<C> constructor = this.constructor(pageClass, PageParameters.class);
        if (constructor != null) {
            PageParameters nullSafeParams = parameters == null ? new PageParameters() : parameters;
            return this.processPage(this.newPage(constructor, nullSafeParams), nullSafeParams);
        }
        return this.processPage(this.newPage(pageClass), parameters);
    }

    private <C extends IRequestablePage> Constructor<C> constructor(Class<C> pageClass, Class<PageParameters> argumentType) {
        Constructor<C> constructor = (Constructor<C>)this.constructorForClass.get(pageClass);
        if (constructor == null) {
            try {
                constructor = pageClass.getDeclaredConstructor(argumentType);
                Constructor<C> tmpConstructor = this.constructorForClass.putIfAbsent(pageClass, constructor);
                if (tmpConstructor != null) {
                    constructor = tmpConstructor;
                }
                log.debug("Found constructor for Page of type '{}' and argument of type '{}'.", (Object)pageClass, (Object)argumentType);
            }
            catch (NoSuchMethodException e) {
                log.debug("Page of type '{}' has not visible constructor with an argument of type '{}'.", (Object)pageClass, (Object)argumentType);
                return null;
            }
        }
        return constructor;
    }

    private <C extends IRequestablePage> C newPage(Constructor<C> constructor, PageParameters argument) {
        try {
            if (argument != null) {
                return (C)((IRequestablePage)constructor.newInstance(argument));
            }
            return (C)((IRequestablePage)constructor.newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (IllegalAccessException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RequestHandlerExecutor.ReplaceHandlerException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof MarkupException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
    }

    private <C extends IRequestablePage> C processPage(C page, PageParameters pageParameters) {
        if (pageParameters != null && page.getPageParameters() != pageParameters) {
            page.getPageParameters().overwriteWith(pageParameters);
        }
        ((Page)page).setWasCreatedBookmarkable(true);
        return page;
    }

    private String createDescription(Constructor<?> constructor, Object argument) {
        StringBuilder msg = new StringBuilder();
        msg.append("Can't instantiate page using constructor '").append(constructor).append('\'');
        if (argument != null) {
            msg.append(" and argument '").append(argument).append('\'');
        }
        msg.append('.');
        if (constructor != null) {
            if (Modifier.isPrivate(constructor.getModifiers())) {
                msg.append(" This constructor is private!");
            } else {
                msg.append(" An exception has been thrown during construction!");
            }
        } else {
            msg.append(" There is no such constructor!");
        }
        return msg.toString();
    }

    @Override
    public <C extends IRequestablePage> boolean isBookmarkable(Class<C> pageClass) {
        Boolean bookmarkable = (Boolean)this.pageToBookmarkableCache.get(pageClass.getName());
        if (bookmarkable == null) {
            Boolean tmpBookmarkable;
            try {
                if (pageClass.getDeclaredConstructor(new Class[0]) != null) {
                    bookmarkable = Boolean.TRUE;
                }
            }
            catch (Exception ignore) {
                try {
                    if (pageClass.getDeclaredConstructor(PageParameters.class) != null) {
                        bookmarkable = Boolean.TRUE;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bookmarkable == null) {
                bookmarkable = Boolean.FALSE;
            }
            if ((tmpBookmarkable = this.pageToBookmarkableCache.putIfAbsent(pageClass.getName(), bookmarkable)) != null) {
                bookmarkable = tmpBookmarkable;
            }
        }
        return bookmarkable;
    }
}

