/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Stage;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IBehaviorInstantiationListener;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.guice.GuiceFieldValueFactory;
import org.apache.wicket.guice.GuiceInjectorHolder;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.injection.Injector;

public class GuiceComponentInjector
extends Injector
implements IComponentInstantiationListener,
IBehaviorInstantiationListener {
    private final IFieldValueFactory fieldValueFactory;

    public GuiceComponentInjector(Application app) {
        this(app, new Module[0]);
    }

    public GuiceComponentInjector(Application app, Module ... modules) {
        this(app, Guice.createInjector((Stage)(app.usesDeploymentConfig() ? Stage.PRODUCTION : Stage.DEVELOPMENT), (Module[])modules), true);
    }

    public GuiceComponentInjector(Application app, com.google.inject.Injector injector) {
        this(app, injector, true);
    }

    public GuiceComponentInjector(Application app, com.google.inject.Injector injector, boolean wrapInProxies) {
        app.setMetaData(GuiceInjectorHolder.INJECTOR_KEY, (Object)new GuiceInjectorHolder(injector));
        this.fieldValueFactory = new GuiceFieldValueFactory(wrapInProxies);
        app.getBehaviorInstantiationListeners().add((Object)this);
        this.bind(app);
    }

    public void inject(Object object) {
        this.inject(object, this.fieldValueFactory);
    }

    public void onInstantiation(Component component) {
        this.inject(component);
    }

    public void onInstantiation(Behavior behavior) {
        this.inject(behavior);
    }
}

