/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.status;

import jakarta.batch.runtime.BatchStatus;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.controller.chunk.PersistentDataWrapper;
import org.apache.batchee.container.util.TCCLObjectInputStream;

public class StepStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long stepExecutionId;
    private BatchStatus batchStatus;
    private String exitStatus;
    private int startCount;
    private PersistentDataWrapper persistentUserData;
    private Integer numPartitions;
    private long lastRunStepExecutionId;

    public StepStatus(long stepExecutionId, int startCount) {
        this.startCount = startCount;
        this.stepExecutionId = stepExecutionId;
        this.lastRunStepExecutionId = stepExecutionId;
        this.batchStatus = BatchStatus.STARTING;
    }

    public StepStatus(long stepExecutionId) {
        this(stepExecutionId, 1);
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public String toString() {
        return "stepExecutionId: " + this.stepExecutionId + ",batchStatus: " + this.batchStatus + ",exitStatus: " + this.exitStatus + ",startCount: " + this.startCount + ",persistentUserData: " + this.persistentUserData + ",numPartitions: " + this.numPartitions;
    }

    public long getStepExecutionId() {
        return this.stepExecutionId;
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void incrementStartCount() {
        ++this.startCount;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setPersistentUserData(PersistentDataWrapper persistentUserData) {
        this.persistentUserData = persistentUserData;
    }

    public byte[] getRawPersistentUserData() {
        if (this.persistentUserData != null) {
            return this.persistentUserData.getPersistentDataBytes();
        }
        return null;
    }

    public Serializable getPersistentUserData() {
        if (this.persistentUserData != null) {
            Serializable persistentObject;
            byte[] persistentToken = this.persistentUserData.getPersistentDataBytes();
            ByteArrayInputStream persistentByteArrayInputStream = new ByteArrayInputStream(persistentToken);
            try {
                TCCLObjectInputStream persistentOIS = new TCCLObjectInputStream(persistentByteArrayInputStream);
                persistentObject = (Serializable)Serializable.class.cast(persistentOIS.readObject());
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
            return persistentObject;
        }
        return null;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    public void setStepExecutionId(long stepExecutionId) {
        this.lastRunStepExecutionId = this.stepExecutionId = stepExecutionId;
    }

    public long getLastRunStepExecutionId() {
        return this.lastRunStepExecutionId;
    }

    public void setLastRunStepExecutionId(long lastRunStepExecutionId) {
        this.lastRunStepExecutionId = lastRunStepExecutionId;
    }
}

