/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Serializable;

public class Injection
implements Serializable {
    private static final long serialVersionUID = 4009121701163822665L;
    private final String targetClass;
    private final String name;
    private final String jndiName;

    public Injection(String targetClass, String name, String jndiName) {
        if (targetClass == null) {
            throw new NullPointerException("targetClass is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (jndiName == null) {
            throw new NullPointerException("jndiName is null");
        }
        this.targetClass = targetClass;
        this.name = name;
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Injection injection = (Injection)o;
        return this.name.equals(injection.name) && this.targetClass.equals(injection.targetClass);
    }

    public int hashCode() {
        int result = this.targetClass.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return this.targetClass + "." + this.name + " -> " + this.jndiName;
    }
}

