/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import jakarta.validation.ValidationException;
import jakarta.validation.spi.ConfigurationState;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.MetadataSource;
import org.apache.bval.jsr.metadata.ValidatorMappingProvider;
import org.apache.bval.jsr.metadata.XmlBuilder;
import org.apache.bval.jsr.metadata.XmlValidationMappingProvider;
import org.apache.bval.jsr.xml.ConstraintDefinitionType;
import org.apache.bval.jsr.xml.ConstraintMappingsType;
import org.apache.bval.jsr.xml.SchemaManager;
import org.apache.bval.jsr.xml.ValidatedByType;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.xml.sax.InputSource;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class ValidationMappingParser
implements MetadataSource {
    private static final SchemaManager SCHEMA_MANAGER = new SchemaManager.Builder().add(XmlBuilder.Version.v10.getId(), "http://jboss.org/xml/ns/javax/validation/mapping", "META-INF/validation-mapping-1.0.xsd").add(XmlBuilder.Version.v11.getId(), "http://jboss.org/xml/ns/javax/validation/mapping", "META-INF/validation-mapping-1.1.xsd").add(XmlBuilder.Version.v20.getId(), "http://xmlns.jcp.org/xml/ns/validation/mapping", "META-INF/validation-mapping-2.0.xsd").add(XmlBuilder.Version.v30.getId(), "https://jakarta.ee/xml/ns/validation/mapping", "META-INF/validation-mapping-3.0.xsd").build();
    private ApacheValidatorFactory validatorFactory;

    @Override
    public void initialize(ApacheValidatorFactory validatorFactory) {
        this.validatorFactory = Validate.notNull(validatorFactory);
    }

    @Override
    public void process(ConfigurationState configurationState, Consumer<ValidatorMappingProvider> addValidatorMappingProvider, BiConsumer<Class<?>, MetadataBuilder.ForBean<?>> addBuilder) {
        Validate.validState(this.validatorFactory != null, "validatorFactory unknown", new Object[0]);
        if (configurationState.isIgnoreXmlConfiguration()) {
            return;
        }
        HashSet beanTypes = new HashSet();
        for (InputStream xmlStream : configurationState.getMappingStreams()) {
            ConstraintMappingsType mapping = this.parseXmlMappings(xmlStream);
            Optional.of(mapping).map(this::toMappingProvider).ifPresent(addValidatorMappingProvider);
            Map<Class<?>, MetadataBuilder.ForBean<?>> builders = new XmlBuilder(this.validatorFactory, mapping).forBeans();
            if (Collections.disjoint(beanTypes, builders.keySet())) {
                builders.forEach(addBuilder::accept);
                beanTypes.addAll(builders.keySet());
                continue;
            }
            Exceptions.raise(ValidationException::new, builders.keySet().stream().filter(beanTypes::contains).map(Class::getName).collect(Collectors.joining("bean classes specified multiple times for XML validation mapping: [", "; ", "]")), new Object[0]);
        }
    }

    private ConstraintMappingsType parseXmlMappings(InputStream in) {
        try {
            ConstraintMappingsType constraintMappingsType = SCHEMA_MANAGER.unmarshal(new InputSource(in), ConstraintMappingsType.class);
            return constraintMappingsType;
        }
        catch (Exception e) {
            throw new ValidationException("Failed to parse XML deployment descriptor file.", (Throwable)e);
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
    }

    private ValidatorMappingProvider toMappingProvider(ConstraintMappingsType mapping) {
        if (mapping.getConstraintDefinition().isEmpty()) {
            return null;
        }
        HashMap<Class<? extends Annotation>, ValidatedByType> validatorMappings = new HashMap<Class<? extends Annotation>, ValidatedByType>();
        for (ConstraintDefinitionType constraintDefinition : mapping.getConstraintDefinition()) {
            String annotationClassName = constraintDefinition.getAnnotation();
            Class<?> clazz = this.loadClass(annotationClassName, mapping.getDefaultPackage());
            Exceptions.raiseUnless(clazz.isAnnotation(), ValidationException::new, "%s is not an annotation", annotationClassName);
            Class<Annotation> annotationClass = clazz.asSubclass(Annotation.class);
            Exceptions.raiseIf(validatorMappings.containsKey(annotationClass), ValidationException::new, "XML constraint validator(s) for %s already configured.", annotationClass);
            validatorMappings.put(annotationClass, constraintDefinition.getValidatedBy());
        }
        return new XmlValidationMappingProvider(validatorMappings, cn -> this.toQualifiedClassName((String)cn, mapping.getDefaultPackage()));
    }

    private Class<?> loadClass(String className, String defaultPackage) {
        String fqn = this.toQualifiedClassName(className, defaultPackage);
        try {
            return Reflection.toClass(fqn, Reflection.loaderFromThreadOrClass(ValidationMappingParser.class));
        }
        catch (ClassNotFoundException ex) {
            throw Exceptions.create(ValidationException::new, ex, "Unable to load class: %s", fqn);
        }
    }

    private String toQualifiedClassName(String className, String defaultPackage) {
        if (!this.isQualifiedClass((String)className)) {
            className = ((String)className).startsWith("[L") && ((String)className).endsWith(";") ? "[L" + defaultPackage + "." + ((String)className).substring(2) : defaultPackage + "." + (String)className;
        }
        return className;
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.indexOf(46) >= 0;
    }
}

