/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.handler.rotating;

import java.util.concurrent.TimeUnit;

class Duration {
    private long time;
    private TimeUnit unit = TimeUnit.MILLISECONDS;

    private Duration() {
    }

    private Duration(long time, TimeUnit unit) {
        this.time = time;
        this.unit = unit;
    }

    Duration(String string) {
        this(string, null);
    }

    private Duration(String string, TimeUnit defaultUnit) {
        String[] strings = string.split(",| and ");
        Duration total = new Duration();
        for (String value : strings) {
            char c;
            int i;
            Duration part = new Duration();
            String s = value.trim();
            StringBuilder t = new StringBuilder();
            StringBuilder u = new StringBuilder();
            for (i = 0; i < s.length() && (Character.isDigit(c = s.charAt(i)) || i == 0 && c == '-'); ++i) {
                t.append(c);
            }
            if (t.length() == 0) {
                Duration.invalidFormat(s);
            }
            while (i < s.length() && Character.isWhitespace(c = s.charAt(i))) {
                ++i;
            }
            while (i < s.length()) {
                c = s.charAt(i);
                if (Character.isLetter(c)) {
                    u.append(c);
                } else {
                    Duration.invalidFormat(s);
                }
                ++i;
            }
            part.time = Long.parseLong(t.toString());
            part.unit = Duration.parseUnit(u.toString());
            if (part.unit == null) {
                part.unit = defaultUnit;
            }
            total = total.add(part);
        }
        this.time = total.time;
        this.unit = total.unit;
    }

    public long asMillis() {
        return this.unit.toMillis(this.time);
    }

    public Duration add(Duration that) {
        Normalize n = new Normalize(this, that);
        return new Duration(n.a + n.b, n.base);
    }

    private static void invalidFormat(String text) {
        throw new IllegalArgumentException("Illegal duration format: '" + text + "'.  Valid examples are '10s' or '10 seconds'.");
    }

    private static TimeUnit parseUnit(String u) {
        if (u.length() == 0) {
            return null;
        }
        if ("NANOSECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANOSECOND".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANOS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANO".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("MICROSECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICROSECOND".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICROS".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICRO".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MILLISECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLISECOND".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLIS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLI".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("SECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("SECOND".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("SEC".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("S".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("MINUTES".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("MINUTE".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("MIN".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("M".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("HOURS".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HOUR".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HRS".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HR".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("H".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("DAYS".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        if ("DAY".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        if ("D".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Unknown time unit '" + u + "'");
    }

    private static final class Normalize {
        private final long a;
        private final long b;
        private final TimeUnit base;

        private Normalize(Duration a, Duration b) {
            this.base = Normalize.lowest(a, b);
            this.a = a.unit == null ? a.time : this.base.convert(a.time, a.unit);
            this.b = b.unit == null ? b.time : this.base.convert(b.time, b.unit);
        }

        private static TimeUnit lowest(Duration a, Duration b) {
            if (a.unit == null) {
                return b.unit;
            }
            if (b.unit == null) {
                return a.unit;
            }
            if (a.time == 0L) {
                return b.unit;
            }
            if (b.time == 0L) {
                return a.unit;
            }
            return TimeUnit.values()[Math.min(a.unit.ordinal(), b.unit.ordinal())];
        }
    }
}

