/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.FilterRankingStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class MatchPredicateStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final MatchPredicateStrategy INSTANCE = new MatchPredicateStrategy();
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = Collections.singleton(IdentityRemovalStrategy.class);
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> POSTS = Collections.singleton(FilterRankingStrategy.class);

    private MatchPredicateStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!TraversalHelper.hasStepOfClass(MatchStep.class, traversal)) {
            return;
        }
        TraversalHelper.getStepsOfClass(MatchStep.class, traversal).forEach(matchStep -> {
            Step<Object, ?> nextStep = matchStep.getNextStep();
            while (nextStep instanceof WherePredicateStep || nextStep instanceof WhereTraversalStep || nextStep instanceof DedupGlobalStep && !((DedupGlobalStep)nextStep).getScopeKeys().isEmpty() && ((DedupGlobalStep)nextStep).getLocalChildren().isEmpty() || nextStep instanceof SelectStep && ((SelectStep)nextStep).getLocalChildren().isEmpty() || nextStep instanceof SelectOneStep && ((SelectOneStep)nextStep).getLocalChildren().isEmpty()) {
                if (nextStep instanceof WherePredicateStep || nextStep instanceof WhereTraversalStep) {
                    traversal.removeStep(nextStep);
                    matchStep.addGlobalChild(traversal instanceof GraphTraversal ? new DefaultGraphTraversal().addStep(nextStep) : new DefaultTraversal().addStep(nextStep));
                    nextStep = matchStep.getNextStep();
                    continue;
                }
                if (nextStep instanceof DedupGlobalStep && !((DedupGlobalStep)nextStep).getScopeKeys().isEmpty() && ((DedupGlobalStep)nextStep).getLocalChildren().isEmpty() && !TraversalHelper.onGraphComputer(traversal)) {
                    traversal.removeStep(nextStep);
                    matchStep.setDedupLabels(((DedupGlobalStep)nextStep).getScopeKeys());
                    nextStep = matchStep.getNextStep();
                    continue;
                }
                if (!nextStep.getLabels().isEmpty()) break;
                nextStep = nextStep.getNextStep();
            }
        });
    }

    public static MatchPredicateStrategy instance() {
        return INSTANCE;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPost() {
        return POSTS;
    }
}

