/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.auth;

import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialTraversal;
import org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialTraversalSource;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleAuthenticator.class);
    private static final byte NUL = 0;
    private CredentialTraversalSource credentialStore;
    public static final String CONFIG_CREDENTIALS_DB = "credentialsDb";

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    @Override
    public void setup(Map<String, Object> config) {
        logger.info("Initializing authentication with the {}", (Object)SimpleAuthenticator.class.getName());
        if (null == config) {
            throw new IllegalArgumentException(String.format("Could not configure a %s - provide a 'config' in the 'authentication' settings", SimpleAuthenticator.class.getName()));
        }
        if (!config.containsKey(CONFIG_CREDENTIALS_DB)) {
            throw new IllegalStateException(String.format("Credentials configuration missing the %s key that points to a graph config file", CONFIG_CREDENTIALS_DB));
        }
        Graph graph = GraphFactory.open((String)((String)config.get(CONFIG_CREDENTIALS_DB)));
        if (graph instanceof TinkerGraph) {
            TinkerGraph tinkerGraph = (TinkerGraph)graph;
            tinkerGraph.createIndex("username", Vertex.class);
        }
        this.credentialStore = (CredentialTraversalSource)graph.traversal(CredentialTraversalSource.class);
        logger.info("CredentialGraph initialized at {}", (Object)this.credentialStore);
    }

    @Override
    public Authenticator.SaslNegotiator newSaslNegotiator(InetAddress remoteAddress) {
        return new PlainTextSaslAuthenticator();
    }

    @Override
    public AuthenticatedUser authenticate(Map<String, String> credentials) throws AuthenticationException {
        if (!credentials.containsKey("username")) {
            throw new IllegalArgumentException(String.format("Credentials must contain a %s", "username"));
        }
        if (!credentials.containsKey("password")) {
            throw new IllegalArgumentException(String.format("Credentials must contain a %s", "password"));
        }
        String username = credentials.get("username");
        String password = credentials.get("password");
        CredentialTraversal t = this.credentialStore.users(username, new String[0]);
        if (!t.hasNext()) {
            throw new AuthenticationException("Username and/or password are incorrect");
        }
        Vertex user = (Vertex)t.next();
        if (t.hasNext()) {
            logger.warn("There is more than one user with the username [{}] - usernames must be unique", (Object)username);
            throw new AuthenticationException("Username and/or password are incorrect");
        }
        String hash = (String)user.value("password");
        if (!BCrypt.checkpw((String)password, (String)hash)) {
            throw new AuthenticationException("Username and/or password are incorrect");
        }
        return new AuthenticatedUser(username);
    }

    private class PlainTextSaslAuthenticator
    implements Authenticator.SaslNegotiator {
        private boolean complete = false;
        private String username;
        private String password;

        private PlainTextSaslAuthenticator() {
        }

        @Override
        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            this.decodeCredentials(clientResponse);
            this.complete = true;
            return null;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            if (!this.complete) {
                throw new AuthenticationException("SASL negotiation not complete");
            }
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", this.username);
            credentials.put("password", this.password);
            return SimpleAuthenticator.this.authenticate(credentials);
        }

        private void decodeCredentials(byte[] bytes) throws AuthenticationException {
            byte[] user = null;
            byte[] pass = null;
            int end = bytes.length;
            for (int i = bytes.length - 1; i >= 0; --i) {
                if (bytes[i] != 0) continue;
                if (pass == null) {
                    pass = Arrays.copyOfRange(bytes, i + 1, end);
                } else if (user == null) {
                    user = Arrays.copyOfRange(bytes, i + 1, end);
                }
                end = i;
            }
            if (null == user) {
                throw new AuthenticationException("Authentication ID must not be null");
            }
            if (null == pass) {
                throw new AuthenticationException("Password must not be null");
            }
            this.username = new String(user, StandardCharsets.UTF_8);
            this.password = new String(pass, StandardCharsets.UTF_8);
        }
    }
}

