/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.iosp.BitReader;
import ucar.unidata.io.RandomAccessFile;

public class Grib1DataReader {
    private static final Logger logger = LoggerFactory.getLogger(Grib1DataReader.class);
    private static final float staticMissingValue = Float.NaN;
    private final int decimalScale;
    private final int scanMode;
    private final int nx;
    private final int ny;
    private final int nPts;
    private final long startPos;

    public Grib1DataReader(int decimalScale, int scanMode, int nx, int ny, int nPts, long startPos) {
        this.decimalScale = decimalScale;
        this.scanMode = scanMode;
        this.nx = nx;
        this.ny = ny;
        this.nPts = nPts;
        this.startPos = startPos;
    }

    public float[] getData(RandomAccessFile raf, byte[] bitmap) throws IOException {
        float[] values;
        raf.seek(this.startPos);
        int msgLength = GribNumbers.uint3(raf);
        int flag = raf.read();
        if ((flag & 0xC0) != 0) {
            logger.error("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data and simple packing for {}", (Object)raf.getLocation());
            throw new IllegalStateException("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data and simple packing ");
        }
        int unusedbits = flag & 0xF;
        int binscale = GribNumbers.int2(raf);
        float refvalue = GribNumbers.float4(raf);
        int numbits = raf.read();
        boolean isConstant = numbits == 0;
        double pow10 = Math.pow(10.0, -this.decimalScale);
        float ref = (float)(pow10 * (double)refvalue);
        float scale = (float)(pow10 * Math.pow(2.0, binscale));
        if (bitmap != null) {
            if (8 * bitmap.length < this.nPts) {
                logger.error("Bitmap section length = {} != grid length {} ({},{}) for {}", bitmap.length, this.nx * this.ny, this.nx, this.ny, raf.getLocation());
                throw new IllegalStateException("Bitmap section length!= grid length");
            }
            BitReader reader = new BitReader(raf, this.startPos + 11L);
            values = new float[this.nPts];
            for (int i = 0; i < this.nPts; ++i) {
                if ((bitmap[i / 8] & GribNumbers.bitmask[i % 8]) != 0) {
                    if (!isConstant) {
                        values[i] = ref + scale * (float)reader.bits2UInt(numbits);
                        continue;
                    }
                    values[i] = ref;
                    continue;
                }
                values[i] = Float.NaN;
            }
            this.scanningModeCheck(values, this.scanMode, this.nx);
        } else if (!isConstant) {
            values = this.nx != -1 && this.ny != -1 ? new float[this.nx * this.ny] : new float[((msgLength - 11) * 8 - unusedbits) / numbits];
            BitReader reader = new BitReader(raf, this.startPos + 11L);
            for (int i = 0; i < values.length; ++i) {
                values[i] = ref + scale * (float)reader.bits2UInt(numbits);
            }
            this.scanningModeCheck(values, this.scanMode, this.nx);
        } else {
            values = new float[this.nx * this.ny];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ref;
            }
        }
        return values;
    }

    int[] getDataRaw(RandomAccessFile raf, byte[] bitmap) throws IOException {
        raf.seek(this.startPos);
        int msgLength = GribNumbers.uint3(raf);
        int unusedbits = raf.read();
        if ((unusedbits & 0xC0) != 0) {
            logger.error("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data and simple packing for {}", (Object)raf.getLocation());
            throw new IllegalStateException("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data and simple packing ");
        }
        int binscale = GribNumbers.int2(raf);
        float refvalue = GribNumbers.float4(raf);
        int numbits = raf.read();
        boolean isConstant = numbits == 0;
        BitReader reader = new BitReader(raf, this.startPos + 11L);
        int[] ivals = new int[this.nPts];
        for (int i = 0; i < this.nPts; ++i) {
            ivals[i] = (int)reader.bits2UInt(numbits);
        }
        return ivals;
    }

    private void scanningModeCheck(float[] data, int scanMode, int Xlength) {
        if (Xlength == -1) {
            return;
        }
        if (scanMode != 0 && scanMode != 64 && (scanMode == 128 || scanMode == 192)) {
            int mid = Xlength / 2;
            for (int index = 0; index < data.length; index += Xlength) {
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = data[index + idx];
                    data[index + idx] = data[index + Xlength - idx - 1];
                    data[index + Xlength - idx - 1] = tmp;
                }
            }
        }
    }
}

