/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Collection;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStoreRegistry;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.image.DataStoreFilter;
import org.apache.sis.util.Static;

public final class DataStores
extends Static {
    private DataStores() {
    }

    public static Collection<DataStoreProvider> providers() {
        return DataStoreRegistry.INSTANCE;
    }

    public static String probeContentType(Object storage) throws DataStoreException {
        return DataStoreRegistry.INSTANCE.probeContentType(storage);
    }

    public static DataStore open(Object storage) throws UnsupportedStorageException, DataStoreException {
        return DataStoreRegistry.INSTANCE.open(storage, Capability.READ, null);
    }

    public static DataStore openWritable(Object storage, String preferredFormat) throws UnsupportedStorageException, DataStoreException {
        DataStoreFilter preferred = null;
        if (preferredFormat != null) {
            preferred = new DataStoreFilter(preferredFormat, true);
        }
        return DataStoreRegistry.INSTANCE.open(storage, Capability.WRITE, preferred);
    }
}

