/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.GeocentricAffine;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform2D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    private static final double IDENTITY_TOLERANCE = 1.0E-16;
    protected final MathTransform transform1;
    protected final MathTransform transform2;
    private MathTransform inverse;

    protected ConcatenatedTransform(MathTransform transform1, MathTransform transform2) {
        this.transform1 = transform1;
        this.transform2 = transform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Resources.format((short)3, ConcatenatedTransform.getName(transform1), ConcatenatedTransform.getName(transform2)));
        }
    }

    public static MathTransform create(MathTransform tr1, MathTransform tr2, MathTransformFactory factory) throws FactoryException, MismatchedDimensionException {
        int dim2;
        int dim1 = tr1.getTargetDimensions();
        if (dim1 != (dim2 = tr2.getSourceDimensions())) {
            throw new MismatchedDimensionException(Resources.format((short)3, ConcatenatedTransform.getName(tr1), ConcatenatedTransform.getName(tr2)) + " " + Errors.format((short)80, dim1, dim2));
        }
        MathTransform mt = ConcatenatedTransform.tryOptimized(tr1, tr2, factory);
        if (mt != null) {
            return mt;
        }
        int dimSource = tr1.getSourceDimensions();
        int dimTarget = tr2.getTargetDimensions();
        if (dimSource == 1 && dimTarget == 1) {
            if (tr1 instanceof MathTransform1D && tr2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D((MathTransform1D)tr1, (MathTransform1D)tr2);
            }
            return new ConcatenatedTransform1D(tr1, tr2);
        }
        if (dimSource == 2 && dimTarget == 2) {
            if (tr1 instanceof MathTransform2D && tr2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D((MathTransform2D)tr1, (MathTransform2D)tr2);
            }
            return new ConcatenatedTransform2D(tr1, tr2);
        }
        if (dimSource == dim1 && dimTarget == dim2) {
            return new ConcatenatedTransformDirect(tr1, tr2);
        }
        return new ConcatenatedTransform(tr1, tr2);
    }

    private static MathTransform tryOptimized(MathTransform tr1, MathTransform tr2, MathTransformFactory factory) throws FactoryException {
        MathTransform optimized;
        if (tr1.isIdentity()) {
            return tr2;
        }
        if (tr2.isIdentity()) {
            return tr1;
        }
        int stepCount = 0;
        MathTransform shortest = null;
        boolean inverseCaseTested = false;
        if (tr1 instanceof AbstractMathTransform) {
            optimized = ((AbstractMathTransform)tr1).tryConcatenate(false, tr2, factory);
            inverseCaseTested = true;
            if (optimized != null) {
                stepCount = ConcatenatedTransform.getStepCount(optimized);
                shortest = optimized;
            }
        }
        if (tr2 instanceof AbstractMathTransform) {
            optimized = ((AbstractMathTransform)tr2).tryConcatenate(true, tr1, factory);
            inverseCaseTested = true;
            if (optimized != null) {
                if (shortest == null || ConcatenatedTransform.getStepCount(optimized) < stepCount) {
                    return optimized;
                }
                shortest = optimized;
            }
        }
        if (shortest != null) {
            return shortest;
        }
        if (!inverseCaseTested && (ConcatenatedTransform.isInverseEquals(tr1, tr2) || ConcatenatedTransform.isInverseEquals(tr2, tr1))) {
            assert (tr1.getSourceDimensions() == tr2.getTargetDimensions());
            assert (tr1.getTargetDimensions() == tr2.getSourceDimensions());
            return MathTransforms.identity(tr1.getSourceDimensions());
        }
        MathTransform concatenated = ConcatenatedTransform.multiply(tr1, tr2, factory);
        if (concatenated instanceof AbstractLinearTransform) {
            AbstractLinearTransform impl = (AbstractLinearTransform)concatenated;
            if (impl.inverse == null) {
                try {
                    MathTransform inverse = ConcatenatedTransform.multiply(tr2.inverse(), tr1.inverse(), factory);
                    if (inverse != null) {
                        if (inverse.isIdentity()) {
                            return inverse;
                        }
                        if (inverse instanceof LinearTransform) {
                            impl.inverse = (LinearTransform)inverse;
                        }
                    }
                }
                catch (NoninvertibleTransformException e) {
                    Logging.recoverableException(LOGGER, ConcatenatedTransform.class, "create", e);
                }
            }
        }
        return concatenated;
    }

    private static MathTransform multiply(MathTransform tr1, MathTransform tr2, MathTransformFactory factory) throws FactoryException {
        Matrix matrix2;
        Matrix matrix1 = MathTransforms.getMatrix(tr1);
        if (matrix1 != null && (matrix2 = MathTransforms.getMatrix(tr2)) != null) {
            MatrixSIS matrix = Matrices.multiply(matrix2, matrix1);
            if (Matrices.isIdentity(matrix, 1.0E-16)) {
                return MathTransforms.identity(matrix.getNumRow() - 1);
            }
            if (factory != null) {
                return factory.createAffineTransform(matrix);
            }
            return MathTransforms.linear(matrix);
        }
        return null;
    }

    private static String getName(MathTransform transform) {
        String name;
        ParameterValueGroup params = null;
        if (transform instanceof AbstractMathTransform) {
            params = ((AbstractMathTransform)transform).getContextualParameters();
        }
        if (params == null && transform instanceof Parameterized) {
            params = ((Parameterized)((Object)transform)).getParameterValues();
        }
        if (params != null && (name = Strings.trimOrNull(params.getDescriptor().getName().getCode())) != null) {
            return name;
        }
        return Classes.getShortClassName(transform);
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    @Override
    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    private int getStepCount() {
        return ConcatenatedTransform.getStepCount(this.transform1) + ConcatenatedTransform.getStepCount(this.transform2);
    }

    private static int getStepCount(MathTransform transform) {
        if (transform.isIdentity()) {
            return 0;
        }
        if (!(transform instanceof ConcatenatedTransform)) {
            return 1;
        }
        return ((ConcatenatedTransform)transform).getStepCount();
    }

    public final List<MathTransform> getSteps() {
        ArrayList<MathTransform> transforms = new ArrayList<MathTransform>(5);
        this.getSteps(transforms);
        return transforms;
    }

    private List<Object> getPseudoSteps() {
        ArrayList<Object> transforms = new ArrayList<Object>();
        this.getSteps(transforms);
        for (int i = 0; i < transforms.size(); ++i) {
            Object step = transforms.get(i);
            if (!(step instanceof AbstractMathTransform)) continue;
            i = ((AbstractMathTransform)step).beforeFormat(transforms, i, false);
        }
        Matrix after = null;
        int i = transforms.size();
        while (--i >= 0) {
            Object step = transforms.get(i);
            if (step instanceof Matrix) {
                if (after != null) {
                    MatrixSIS merged = Matrices.multiply(after, (Matrix)step);
                    if (merged.isIdentity()) {
                        transforms.subList(i, i + 2).clear();
                        after = null;
                        continue;
                    }
                    transforms.set(i, MathTransforms.linear(merged));
                    transforms.remove(i + 1);
                    after = merged;
                    continue;
                }
                after = (Matrix)step;
                continue;
            }
            after = null;
        }
        GeocentricAffine.asDatumShift(transforms);
        return transforms;
    }

    private void getSteps(List<? super MathTransform> transforms) {
        if (this.transform1 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform1).getSteps(transforms);
        } else {
            transforms.add(this.transform1);
        }
        if (this.transform2 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform2).getSteps(transforms);
        } else {
            transforms.add(this.transform2);
        }
    }

    private Parameterized getParameterised() {
        Parameterized param = null;
        List<Object> transforms = this.getPseudoSteps();
        if (transforms.size() == 1 || Semaphores.query(8)) {
            for (Object candidate : transforms) {
                if (candidate instanceof Matrix || candidate instanceof LinearTransform) continue;
                if (param == null && candidate instanceof Parameterized) {
                    param = (Parameterized)candidate;
                    continue;
                }
                return null;
            }
        }
        return param;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Parameterized param = this.getParameterised();
        return param != null ? param.getParameterDescriptors() : null;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameterized param = this.getParameterised();
        return param != null ? param.getParameterValues() : null;
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        assert (this.isValid());
        return this.transform2.transform(this.transform1.transform(ptSrc, null), ptDst);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        int offset;
        double[] buffer;
        int targetDim;
        assert (this.isValid());
        int bufferDim = this.transform2.getSourceDimensions();
        if (bufferDim > (targetDim = this.transform2.getTargetDimensions())) {
            buffer = new double[bufferDim];
            offset = 0;
        } else {
            buffer = dstPts;
            offset = dstOff;
        }
        if (derivate) {
            Matrix matrix1 = MathTransforms.derivativeAndTransform(this.transform1, srcPts, srcOff, buffer, offset);
            Matrix matrix2 = MathTransforms.derivativeAndTransform(this.transform2, buffer, offset, dstPts, dstOff);
            return Matrices.multiply(matrix2, matrix1);
        }
        this.transform1.transform(srcPts, srcOff, buffer, offset, 1);
        this.transform2.transform(buffer, offset, dstPts, dstOff, 1);
        return null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int targetDim;
        assert (this.isValid());
        int bufferDim = this.transform2.getSourceDimensions();
        if (bufferDim <= (targetDim = this.transform2.getTargetDimensions())) {
            this.transform1.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            this.transform2.transform(dstPts, dstOff, dstPts, dstOff, numPts);
            return;
        }
        if (numPts <= 0) {
            return;
        }
        boolean descending = false;
        int sourceDim = this.transform1.getSourceDimensions();
        int numBuf = numPts;
        int length = numBuf * bufferDim;
        if (length > 512) {
            numBuf = Math.max(1, 512 / bufferDim);
            if (srcPts == dstPts) {
                switch (IterationStrategy.suggest(srcOff, numBuf * sourceDim, dstOff, numBuf * targetDim, numPts)) {
                    default: {
                        numBuf = numPts;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int shift = numPts - numBuf;
                        srcOff += shift * sourceDim;
                        sourceDim = -sourceDim;
                        dstOff += shift * targetDim;
                        targetDim = -targetDim;
                        descending = true;
                        break;
                    }
                }
            }
            length = numBuf * bufferDim;
        }
        double[] buf = new double[length];
        do {
            if (!descending && numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            if (descending && numBuf > (numPts -= numBuf)) {
                numBuf = numPts;
            }
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while (numPts != 0);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        assert (this.isValid());
        if (numPts <= 0) {
            return;
        }
        boolean descending = false;
        int sourceDim = this.transform1.getSourceDimensions();
        int bufferDim = this.transform1.getTargetDimensions();
        int numBuf = numPts;
        int targetDim = this.transform2.getTargetDimensions();
        int dimension = Math.max(targetDim, bufferDim);
        int length = numBuf * dimension;
        if (length > 512) {
            numBuf = Math.max(1, 512 / dimension);
            if (srcPts == dstPts) {
                switch (IterationStrategy.suggest(srcOff, numBuf * sourceDim, dstOff, numBuf * targetDim, numPts)) {
                    default: {
                        numBuf = numPts;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int shift = numPts - numBuf;
                        srcOff += shift * sourceDim;
                        sourceDim = -sourceDim;
                        dstOff += shift * targetDim;
                        targetDim = -targetDim;
                        descending = true;
                        break;
                    }
                }
            }
            length = numBuf * dimension;
        }
        double[] buf = new double[length];
        do {
            if (!descending && numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            if (descending && numBuf > (numPts -= numBuf)) {
                numBuf = numPts;
            }
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while (numPts != 0);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        assert (this.isValid());
        if (numPts <= 0) {
            return;
        }
        int sourceDim = this.transform1.getSourceDimensions();
        int bufferDim = this.transform1.getTargetDimensions();
        int numBuf = numPts;
        int targetDim = this.transform2.getTargetDimensions();
        int dimension = Math.max(targetDim, bufferDim);
        int length = numBuf * dimension;
        if (length > 512) {
            numBuf = Math.max(1, 512 / dimension);
            length = numBuf * dimension;
        }
        double[] buf = new double[length];
        do {
            if (numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while ((numPts -= numBuf) != 0);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int targetDim;
        assert (this.isValid());
        int bufferDim = this.transform2.getSourceDimensions();
        if (bufferDim <= (targetDim = this.transform2.getTargetDimensions())) {
            this.transform1.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            this.transform2.transform(dstPts, dstOff, dstPts, dstOff, numPts);
            return;
        }
        if (numPts <= 0) {
            return;
        }
        int numBuf = numPts;
        int length = numBuf * bufferDim;
        if (length > 512) {
            numBuf = Math.max(1, 512 / bufferDim);
            length = numBuf * bufferDim;
        }
        double[] buf = new double[length];
        int sourceDim = this.getSourceDimensions();
        do {
            if (numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while ((numPts -= numBuf) != 0);
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        Matrix matrix1 = this.transform1.derivative(point);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(point, null));
        return Matrices.multiply(matrix2, matrix1);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        assert (this.isValid());
        if (this.inverse == null) {
            try {
                this.inverse = ConcatenatedTransform.create(this.transform2.inverse(), this.transform1.inverse(), null);
                ConcatenatedTransform.setInverse(this.inverse, this);
            }
            catch (FactoryException e) {
                throw new NoninvertibleTransformException(Resources.format((short)53), e);
            }
        }
        return this.inverse;
    }

    static void setInverse(MathTransform tr, MathTransform inverse) {
        if (tr instanceof ConcatenatedTransform) {
            assert (((ConcatenatedTransform)tr).inverse == null);
            ((ConcatenatedTransform)tr).inverse = inverse;
        }
    }

    @Override
    public final Optional<Envelope> getDomain(DomainDefinition criteria) throws TransformException {
        MathTransform head = this.transform1.inverse();
        criteria.estimateOnInverse(this.transform2.inverse(), head);
        criteria.estimateOnInverse(head);
        return criteria.result();
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        if (applyOtherFirst) {
            MathTransform candidate = ConcatenatedTransform.tryOptimized(other, this.transform1, factory);
            if (candidate != null) {
                return ConcatenatedTransform.create(candidate, this.transform2, factory);
            }
        } else {
            MathTransform candidate = ConcatenatedTransform.tryOptimized(this.transform2, other, factory);
            if (candidate != null) {
                return ConcatenatedTransform.create(this.transform1, candidate, factory);
            }
        }
        return null;
    }

    @Override
    public boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.getSteps().hashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof ConcatenatedTransform) {
            ConcatenatedTransform that = (ConcatenatedTransform)object;
            return Utilities.deepEquals(this.getSteps(), that.getSteps(), mode);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        List<Object> transforms = formatter.getConvention() == Convention.INTERNAL ? this.getSteps() : this.getPseudoSteps();
        if (transforms.size() == 1) {
            return formatter.delegateTo(transforms.get(0));
        }
        for (Object step : transforms) {
            formatter.newLine();
            if (step instanceof FormattableObject) {
                formatter.append((FormattableObject)step);
                continue;
            }
            if (step instanceof MathTransform) {
                formatter.append((MathTransform)step);
                continue;
            }
            formatter.append(MathTransforms.linear((Matrix)step));
        }
        return "Concat_MT";
    }
}

