/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.FileEventStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealValueFileEventStream
extends FileEventStream {
    private static final Logger logger = LoggerFactory.getLogger(RealValueFileEventStream.class);

    public RealValueFileEventStream(String fileName) throws IOException {
        super(fileName);
    }

    public RealValueFileEventStream(String fileName, String encoding) throws IOException {
        super(fileName, encoding);
    }

    public RealValueFileEventStream(File file) throws IOException {
        super(file);
    }

    public static float[] parseContexts(String[] contexts) {
        boolean hasRealValue = false;
        float[] values = new float[contexts.length];
        for (int ci = 0; ci < contexts.length; ++ci) {
            int ei = contexts[ci].lastIndexOf("=");
            if (ei > 0 && ei + 1 < contexts[ci].length()) {
                boolean gotReal = true;
                try {
                    values[ci] = Float.parseFloat(contexts[ci].substring(ei + 1));
                }
                catch (NumberFormatException e) {
                    gotReal = false;
                    logger.error("Unable to determine value in context: {}", (Object)contexts[ci]);
                    values[ci] = 1.0f;
                }
                if (!gotReal) continue;
                if (values[ci] < 0.0f) {
                    throw new RuntimeException("Negative values are not allowed: " + contexts[ci]);
                }
                contexts[ci] = contexts[ci].substring(0, ei);
                hasRealValue = true;
                continue;
            }
            values[ci] = 1.0f;
        }
        if (!hasRealValue) {
            values = null;
        }
        return values;
    }

    @Override
    public Event read() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            int si = line.indexOf(32);
            String outcome = line.substring(0, si);
            String[] contexts = line.substring(si + 1).split(" ");
            float[] values = RealValueFileEventStream.parseContexts(contexts);
            return new Event(outcome, contexts, values);
        }
        return null;
    }
}

