/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.xss.impl.PolicyHandler;
import org.apache.sling.xss.impl.SanitizedResult;
import org.apache.sling.xss.impl.XSSFilterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToHtmlContentContext
implements XSSFilterRule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean check(PolicyHandler policyHandler, String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            try {
                return this.getCleanResults(policyHandler, str).getNumberOfErrors() == 0;
            }
            catch (Exception se) {
                this.logError(se, str);
            }
        }
        return false;
    }

    @Override
    public String filter(PolicyHandler policyHandler, String unsafeString) {
        if (StringUtils.isNotEmpty((CharSequence)unsafeString)) {
            try {
                String results = this.getCleanResults(policyHandler, unsafeString).getSanitizedString();
                if (results != null) {
                    this.log.debug("Protected (HTML -> HTML):\n{}", (Object)results);
                    return results;
                }
            }
            catch (Exception e) {
                this.logError(e, unsafeString);
            }
        }
        return "";
    }

    @Override
    public boolean supportsPolicy() {
        return true;
    }

    private SanitizedResult getCleanResults(PolicyHandler handler, String input) {
        SanitizedResult results;
        try {
            results = handler.getHtmlSanitizer().scan(input);
        }
        catch (StackOverflowError e) {
            this.log.debug("Will perform a second attempt at filtering the following input due to a StackOverflowError:\n{}", (Object)input);
            results = handler.getFallbackHtmlSanitizer().scan(input);
            this.log.debug("Second attempt was successful.");
        }
        return results;
    }

    private void logError(Exception e, String input) {
        this.log.warn("Unable to check input.", (Throwable)e);
        this.log.debug("Provided input: {}", (Object)input);
    }
}

