/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.cache;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IteratorChain<T>
implements Iterator<T> {
    private final Iterable<T>[] lazyIterables;
    private final Iterator<T>[] iterators;
    private int index;

    IteratorChain(Iterable<T>[] lazyIterables) {
        this.lazyIterables = (Iterable[])lazyIterables.clone();
        this.iterators = new Iterator[lazyIterables.length];
    }

    @Override
    public boolean hasNext() {
        for (int i = this.index; i < this.iterators.length; ++i) {
            this.unroll(i);
            if (!this.iterators[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        while (this.index < this.iterators.length) {
            this.unroll(this.index);
            try {
                return this.iterators[this.index].next();
            }
            catch (NoSuchElementException e) {
                ++this.index;
            }
        }
        throw new NoSuchElementException();
    }

    private void unroll(int i) {
        if (null == this.iterators[i]) {
            this.iterators[i] = this.lazyIterables[i].iterator();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

