/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.markup;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Image;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.markup.AbstractImageMediaMarkupBuilder;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@Deprecated
@ConsumerType
public class ResponsiveImageMediaMarkupBuilder
extends AbstractImageMediaMarkupBuilder {
    static final String PROP_RESPONSIVE_SOURCES = "resp-src";
    static final String PROP_SRC = "src";

    @Override
    public final boolean accepts(@NotNull Media media) {
        return media.getMediaRequest().getMediaArgs().isMediaFormatsMandatory() && media.getRendition() != null && media.getRenditions().size() > 1 && media.isValid();
    }

    @Override
    public final HtmlElement<?> build(@NotNull Media media) {
        HtmlElement<?> mediaElement = this.getImageElement(media);
        JSONArray sources = this.getResponsiveImageSources(media);
        this.setResponsiveImageSource(mediaElement, sources, media);
        this.setAdditionalAttributes(mediaElement, media);
        this.applyWcmMarkup(mediaElement, media);
        return mediaElement;
    }

    protected HtmlElement<?> getImageElement(Media media) {
        Image img = new Image();
        Asset asset = media.getAsset();
        String altText = null;
        if (asset != null) {
            altText = asset.getAltText();
        }
        if (StringUtils.isNotEmpty(altText)) {
            img.setAlt(altText);
        }
        return img;
    }

    protected JSONArray getResponsiveImageSources(Media media) {
        Collection<Rendition> renditions = media.getRenditions();
        JSONArray sources = new JSONArray();
        for (Rendition rendition : renditions) {
            sources.put((Object)this.toReponsiveImageSource(media, rendition));
        }
        return sources;
    }

    @SuppressFBWarnings(value={"STYLE"})
    protected JSONObject toReponsiveImageSource(Media media, Rendition rendition) {
        try {
            JSONObject source = new JSONObject();
            MediaFormat mediaFormat = rendition.getMediaFormat();
            source.put("mq", mediaFormat.getProperties().get((Object)"mq"));
            source.put(PROP_SRC, (Object)rendition.getUrl());
            return source;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Error building JSON source.", ex);
        }
    }

    protected void setResponsiveImageSource(HtmlElement<?> mediaElement, JSONArray responsiveImageSources, Media media) {
        mediaElement.setData(PROP_RESPONSIVE_SOURCES, responsiveImageSources.toString());
    }

    @Override
    public final boolean isValidMedia(@NotNull HtmlElement<?> element) {
        if (element instanceof Image) {
            Image img = (Image)element;
            return this.imageSourceIsNotEmpty(img) && !StringUtils.contains((CharSequence)img.getCssClass(), (CharSequence)"wcmio_mediahandler_wcm_dummy");
        }
        return false;
    }

    private boolean imageSourceIsNotEmpty(Image img) {
        String imageSources = img.getData(PROP_RESPONSIVE_SOURCES);
        return StringUtils.isNotBlank((CharSequence)imageSources);
    }
}

