/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Span;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.imagemap.ImageMapArea;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.wcm.commons.util.ToStringStyle;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@ProviderType
public final class Media {
    @NotNull
    private final MediaSource mediaSource;
    @NotNull
    private MediaRequest mediaRequest;
    private HtmlElement<?> element;
    private String url;
    private Asset asset;
    private Collection<Rendition> renditions;
    private CropDimension cropDimension;
    private Integer rotation;
    private List<ImageMapArea> map;
    private MediaInvalidReason mediaInvalidReason;
    private String markup;

    public Media(@NotNull MediaSource mediaSource, @NotNull MediaRequest mediaRequest) {
        this.mediaSource = mediaSource;
        this.mediaRequest = mediaRequest;
    }

    @JsonIgnore
    @NotNull
    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    @JsonIgnore
    @NotNull
    public MediaRequest getMediaRequest() {
        return this.mediaRequest;
    }

    public void setMediaRequest(@NotNull MediaRequest mediaRequest) {
        this.mediaRequest = mediaRequest;
    }

    @JsonIgnore
    public HtmlElement<?> getElement() {
        return this.element;
    }

    @JsonIgnore
    public String getMarkup() {
        if (this.markup == null && this.element != null) {
            if (this.element instanceof Span) {
                StringBuilder result = new StringBuilder();
                for (Element child : this.element.getChildren()) {
                    result.append(child.toString());
                }
                this.markup = result.toString();
            } else {
                this.markup = this.element.toString();
            }
        }
        return this.markup;
    }

    public void setElement(HtmlElement<?> value) {
        this.element = value;
        this.markup = null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @JsonIgnore
    public Rendition getRendition() {
        if (this.renditions == null || this.renditions.isEmpty()) {
            return null;
        }
        return this.renditions.iterator().next();
    }

    public Collection<Rendition> getRenditions() {
        if (this.renditions == null) {
            return ImmutableList.of();
        }
        return this.renditions;
    }

    public void setRenditions(Collection<Rendition> renditions) {
        this.renditions = renditions;
    }

    @JsonIgnore
    @Nullable
    public CropDimension getCropDimension() {
        return this.cropDimension;
    }

    public void setCropDimension(@Nullable CropDimension cropDimension) {
        this.cropDimension = cropDimension;
    }

    @JsonIgnore
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    public void setRotation(@Nullable Integer rotation) {
        this.rotation = rotation;
    }

    @JsonIgnore
    @Nullable
    public List<ImageMapArea> getMap() {
        return this.map;
    }

    public void setMap(@Nullable List<ImageMapArea> map) {
        this.map = map;
    }

    public boolean isValid() {
        return this.mediaInvalidReason == null;
    }

    @JsonIgnore
    public MediaInvalidReason getMediaInvalidReason() {
        return this.mediaInvalidReason;
    }

    public void setMediaInvalidReason(MediaInvalidReason mediaInvalidReason) {
        this.mediaInvalidReason = mediaInvalidReason;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (org.apache.commons.lang3.builder.ToStringStyle)ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
    }
}

