/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.referencing.operation;

import org.apache.sis.io.wkt.Convention;

// Test dependencies
import org.junit.jupiter.api.Test;
import org.apache.sis.test.TestCase;
import static org.apache.sis.referencing.Assertions.assertWktEquals;


/**
 * Tests {@link DefaultFormula}.
 *
 * @author  Martin Desruisseaux (Geomatys)
 */
public final class DefaultFormulaTest extends TestCase {
    /**
     * Creates a new test case.
     */
    public DefaultFormulaTest() {
    }

    /**
     * Tests {@link DefaultFormula#toWKT()}.
     */
    @Test
    public void testWKT() {
        final DefaultFormula formula = new DefaultFormula("Mercator");
        assertWktEquals(Convention.WKT2_SIMPLIFIED, "Formula[“Mercator”]", formula);
        assertWktEquals(Convention.WKT2, "FORMULA[“Mercator”]", formula);
    }
}
