/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.base.URIDataStoreProvider;
import org.apache.sis.storage.geotiff.Compression;
import org.apache.sis.storage.geotiff.FormatModifier;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.WritableStore;
import org.apache.sis.util.Version;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@StoreMetadata(formatName="GeoTIFF", fileSuffixes={"tiff", "tif"}, capabilities={Capability.READ, Capability.WRITE, Capability.CREATE}, resourceTypes={Aggregate.class, GridCoverageResource.class})
public class GeoTiffStoreProvider
extends DataStoreProvider {
    private static final String MIME_TYPE = "image/tiff";
    private static final Version VERSION = new Version("6.0");
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.geotiff");
    static final String MODIFIERS = "modifiers";
    static final String COMPRESSION = "compression";
    private static final ParameterDescriptor<FormatModifier[]> MODIFIERS_PARAM;
    private static final ParameterDescriptor<Compression> COMPRESSION_PARAM;
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR;

    public String getShortName() {
        return "GeoTIFF";
    }

    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return this.probeContent(connector, ByteBuffer.class, buffer -> {
            if (buffer.remaining() < 4) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            switch (buffer.getShort()) {
                case 18761: {
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                case 19789: {
                    switch (buffer.getShort()) {
                        case 42: 
                        case 43: {
                            return new ProbeResult(true, MIME_TYPE, VERSION);
                        }
                    }
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        });
    }

    public DataStore open(StorageConnector connector) throws DataStoreException {
        if (URIDataStoreProvider.isWritable((StorageConnector)connector, (boolean)false)) {
            return new WritableStore(this, connector);
        }
        return new GeoTiffStore(this, connector);
    }

    public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
        Compression compression;
        Parameters p = Parameters.castOrWrap((ParameterValueGroup)parameters);
        StorageConnector connector = new StorageConnector(p.getValue(URIDataStoreProvider.LOCATION_PARAM));
        FormatModifier[] modifiers = (FormatModifier[])p.getValue(MODIFIERS_PARAM);
        if (modifiers != null) {
            connector.setOption(FormatModifier.OPTION_KEY, (Object)modifiers);
        }
        if ((compression = (Compression)p.getValue(COMPRESSION_PARAM)) != null) {
            connector.setOption(Compression.OPTION_KEY, (Object)compression);
        }
        return this.open(connector);
    }

    public Logger getLogger() {
        return LOGGER;
    }

    static {
        ParameterBuilder builder = new ParameterBuilder();
        MODIFIERS_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)MODIFIERS)).setDescription((CharSequence)Vocabulary.formatInternational((short)153))).create(FormatModifier[].class, null);
        COMPRESSION_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)COMPRESSION)).setDescription((CharSequence)Vocabulary.formatInternational((short)273))).create(Compression.class, null);
        OPEN_DESCRIPTOR = ((ParameterBuilder)builder.addName((CharSequence)"GeoTIFF")).createGroup(new GeneralParameterDescriptor[]{URIDataStoreProvider.LOCATION_PARAM, MODIFIERS_PARAM, COMPRESSION_PARAM});
    }
}

