<#--
  ~ Licensed to the Apache Software Foundation (ASF) under one or more
  ~ contributor license agreements.  See the NOTICE file distributed with
  ~ this work for additional information regarding copyright ownership.
  ~ The ASF licenses this file to You under the Apache License, Version 2.0
  ~ (the "License"); you may not use this file except in compliance with
  ~ the License.  You may obtain a copy of the License at
  ~
  ~     http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  -->

<#import "../../../macro/constraints.ftl" as CONSTRAINTS>
CREATE <#if relpersistence!false >UNLOGGED </#if>TABLE IF NOT EXISTS ${schema}.${name}
<#if typname?? >
OF ${typname }
</#if>
<#if like_relation?? || coll_inherits?size gt 0 || columns?size gt 0 || primary_key?size gt 0 || unique_constraint?size gt 0 || foreign_key?size gt 0 || check_constraint?size gt 0 || exclude_constraint?size gt 0 >
(
</#if>
<#if like_relation?? >
LIKE ${like_relation }<#if like_default_value!false >
INCLUDING DEFAULTS</#if><#if like_constraints!false >
INCLUDING CONSTRAINTS</#if><#if like_indexes!false >
INCLUDING INDEXES</#if><#if like_storage!false >
INCLUDING STORAGE</#if><#if  like_comments!false >
INCLUDING COMMENTS</#if><#if  columns?size gt 0 >,
</#if>
</#if>
<#if columns?? && columns?size gt 0 >
<#list columns as c >
<#if c.name?? && c.cltype?? >
<#if c.inheritedfromtable?? >-- Inherited from table ${c.inheritedfromtable}: <#elseif c.inheritedfromtype?? >-- Inherited from type ${c.inheritedfromtype}: </#if>${c.name} ${c.displaytypname}<#if c.collspcname?? && c.collspcname?length gt 0 > COLLATE ${c.collspcname}</#if><#if c.attnotnull!false > NOT NULL</#if><#if c.defval?? && c.defval != ''> DEFAULT ${c.defval}</#if>
<#if c.colconstype?? && c.colconstype == 'i' && c.attidentity?? && c.attidentity != '' >
<#if c.attidentity?? &&  c.attidentity == 'a' > GENERATED ALWAYS AS IDENTITY<#elseif c.attidentity?? && c.attidentity == 'd' > GENERATED BY DEFAULT AS IDENTITY</#if>
<#if c.seqincrement?? || c.seqcycle!false || c.seqincrement?? || c.seqstart?? || c.seqmin?? || c.seqmax?? || c.seqcache?? > ( </#if>
<#if c.seqcycle!false >
CYCLE </#if><#if c.seqincrement?? && c.seqincrement?c?number gt -1 >
INCREMENT ${c.seqincrement?c} </#if><#if c.seqstart?? && c.seqstart?c?number gt -1>
START ${c.seqstart?c} </#if><#if c.seqmin?? && c.seqmin?c?number gt -1>
MINVALUE ${c.seqmin?c} </#if><#if c.seqmax?? && c.seqmax?c?number gt -1>
MAXVALUE ${c.seqmax?c} </#if><#if c.seqcache?? && c.seqcache?c?number gt -1>
CACHE ${c.seqcache?c} </#if>
<#if c.seqincrement?? || c.seqcycle!false || c.seqincrement?? || c.seqstart?? || c.seqmin?? || c.seqmax?? || c.seqcache?? >)</#if>
</#if>
<#if c?counter lt columns?size>,
</#if>
</#if>
</#list>
</#if>
<#if primary_key?size gt 0 ><#if columns?size gt 0 >,</#if>
<@CONSTRAINTS.PRIMARY_KEY data=primary_key[0] /></#if><#if unique_constraint?size gt 0 ><#if columns?size gt 0 || primary_key?size gt 0 >,</#if>
<@CONSTRAINTS.UNIQUE unique_data=unique_constraint /></#if><#if foreign_key?size gt 0 ><#if columns?size gt 0 || primary_key?size gt 0 || unique_constraint?size gt 0 >,</#if>
<@CONSTRAINTS.FOREIGN_KEY foreign_key_data=foreign_key /></#if><#if check_constraint?size gt 0 ><#if columns?size gt 0 || primary_key?size gt 0 || unique_constraint?size gt 0 || foreign_key?size gt 0 >,</#if>
<@CONSTRAINTS.CHECK check_data=check_constraint/></#if><#if exclude_constraint?size gt 0 ><#if columns?size gt 0 || primary_key?size gt 0 || unique_constraint?size gt 0 || foreign_key?size gt 0 || check_constraint?size gt 0 >,</#if>
<@CONSTRAINTS.EXCLUDE exclude_data=exclude_constraint/></#if>
<#if like_relation?? || coll_inherits?size gt 0 || columns?size gt 0 || primary_key?size gt 0 || unique_constraint?size gt 0 || foreign_key?size gt 0 || check_constraint?size gt 0 || exclude_constraint?size gt 0 >
)</#if><#if relkind?? && relkind == 'p' > PARTITION BY ${ partition_scheme }</#if>
<#if coll_inherits?? && coll_inherits?size gt 0>
INHERITS (<#list coll_inherits as val ><#if val?counter != 1 >, </#if>${val}</#list>)
</#if>
WITH (
OIDS = <#if relhasoids!false >TRUE<#else>FALSE</#if><#if fillfactor?? >,
FILLFACTOR = ${ fillfactor }</#if><#if parallel_workers?? && parallel_workers != '' >,
parallel_workers = ${ parallel_workers }</#if><#if toast_tuple_target?? && toast_tuple_target != ''>,
toast_tuple_target = ${ data.toast_tuple_target }</#if><#if autovacuum_enabled?? && (autovacuum_enabled == 't' || autovacuum_enabled == 'f') >,
autovacuum_enabled = <#if autovacuum_enabled == 't' >TRUE<#else >FALSE</#if></#if><#if toast_autovacuum_enabled?? && (toast_autovacuum_enabled == 't' || toast_autovacuum_enabled == 'f')  >,
toast.autovacuum_enabled = <#if toast_autovacuum_enabled == 't' >TRUE<#else >FALSE</#if>
</#if><#if autovacuum_custom!false && vacuum_table?size gt 0 >
<#list vacuum_table as opt ><#if opt.name?? && opt.value?? >
,
${opt.name} = ${opt.value}</#if>
</#list></#if><#if toast_autovacuum!false && vacuum_toast?size gt 0 >
<#list vacuum_toast as opt ><#if opt.name?? && opt.value?? >
,
toast.${opt.name} = ${opt.value}</#if>
</#list></#if>
<#if spcname?? >
)
TABLESPACE ${spcname };
<#else>
);
</#if>
<#if description?? >
COMMENT ON TABLE ${schema}.${name}
IS '${description}';
</#if>
<#if columns?? && columns?size gt 0 >
<#list columns as c >
<#if c.description?? >
COMMENT ON COLUMN ${schema}.${name}.${c.name}
IS '${c.description}';
</#if>
</#list>
</#if>
<@CONSTRAINTS.CONSTRAINT_COMMENTS schema=schema table=name data=primary_key/>
<@CONSTRAINTS.CONSTRAINT_COMMENTS schema=schema table=name data=unique_constraint/>
<@CONSTRAINTS.CONSTRAINT_COMMENTS schema=schema table=name data=foreign_key/>
<@CONSTRAINTS.CONSTRAINT_COMMENTS schema=schema table=name data=check_constraint/>
<@CONSTRAINTS.CONSTRAINT_COMMENTS schema=schema table=name data=exclude_constraint/>
