/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.Collection;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.DelegateNode;
import org.apache.royale.compiler.internal.fxg.dom.IPreserveWhiteSpaceNode;
import org.apache.royale.compiler.internal.fxg.dom.ITextNode;
import org.apache.royale.compiler.internal.fxg.dom.RichTextNode;
import org.apache.royale.compiler.internal.fxg.dom.TextGraphicNode;
import org.apache.royale.compiler.problems.FXGInvalidChildNodeProblem;
import org.apache.royale.compiler.problems.FXGMultipleElementProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class ContentPropertyNode
extends DelegateNode
implements IPreserveWhiteSpaceNode {
    @Override
    public void setDelegate(IFXGNode delegate, Collection<ICompilerProblem> problems) {
        if (!(delegate instanceof ITextNode)) {
            problems.add(new FXGInvalidChildNodeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), this.getNodeName(), delegate.getNodeName()));
            return;
        }
        if (delegate instanceof RichTextNode && ((RichTextNode)delegate).content != null) {
            problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "content"));
            return;
        }
        super.setDelegate(delegate, problems);
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (this.delegate instanceof TextGraphicNode) {
            ((TextGraphicNode)this.delegate).addContentChild(child, problems);
        } else if (this.delegate instanceof RichTextNode) {
            ((RichTextNode)this.delegate).addContentChild(child, problems);
        } else {
            problems.add(new FXGInvalidChildNodeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), child.getNodeName(), this.getNodeName()));
        }
    }
}

