/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher;

import org.apache.royale.test.ant.LoggingUtil;

public enum OperatingSystem {
    WINDOWS,
    MACOSX,
    LINUX;

    private static final String SUN_WINDOWS = "windows";
    private static final String SUN_MACOSX = "mac os x";
    private static final String OPENJDK_MACOSX = "darwin";

    public static OperatingSystem identify() {
        OperatingSystem os = null;
        String env = System.getProperty("os.name").toLowerCase();
        if (env.startsWith(SUN_WINDOWS)) {
            LoggingUtil.log("OS: [Windows]");
            os = WINDOWS;
        } else if (env.contains(SUN_MACOSX) || env.contains(OPENJDK_MACOSX)) {
            LoggingUtil.log("OS: [Mac]");
            os = MACOSX;
        } else {
            LoggingUtil.log("OS: [Linux]");
            os = LINUX;
        }
        return os;
    }
}

