/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.management.amqp.ManagementNode;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectCustomSerialization;

class ManagementOutputConverter {
    private static final List<String> ID_AND_TYPE = Arrays.asList("id", "type");
    private final ManagementNode _managementNode;

    ManagementOutputConverter(ManagementNode managementNode) {
        this._managementNode = managementNode;
    }

    Map<?, ?> convertToOutput(ConfiguredObject<?> object, boolean actuals) {
        Class parentType;
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("identity", object.getId());
        attributes.put("object-path", this._managementNode.generatePath(object));
        attributes.put("type", this._managementNode.getAmqpName(object.getTypeClass()));
        attributes.put("qpid-type", object.getType());
        if (object != this._managementNode.getManagedObject() && !this._managementNode.isSyntheticChildClass(object.getCategoryClass()) && (parentType = object.getModel().getParentType(object.getCategoryClass())) != this._managementNode.getManagedObject().getCategoryClass()) {
            attributes.put(parentType.getSimpleName().toLowerCase(), object.getParent());
        }
        for (String name : object.getAttributeNames()) {
            Object value;
            if (ID_AND_TYPE.contains(name)) continue;
            ConfiguredObjectAttribute attribute = (ConfiguredObjectAttribute)object.getModel().getTypeRegistry().getAttributeTypes(object.getClass()).get(name);
            Object object2 = value = actuals ? object.getActualAttributes().get(name) : object.getAttribute(name);
            if (attribute.isSecureValue(value)) {
                value = object.getAttribute(name);
            }
            if (value == null) continue;
            attributes.put(name, value);
        }
        return this.convertMapToOutput(attributes);
    }

    Object convertObjectToOutput(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof Boolean || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof byte[]) {
            return value;
        }
        if (value instanceof Map) {
            return this.convertMapToOutput((Map)value);
        }
        if (value instanceof Collection) {
            return this.convertCollectionToOutput((Collection)value);
        }
        if (value instanceof ConfiguredObject) {
            return ((ConfiguredObject)value).getName();
        }
        for (ConfiguredObjectCustomSerialization.Converter converter : ConfiguredObjectCustomSerialization.getConverters((boolean)false)) {
            if (!converter.getConversionClass().isAssignableFrom(value.getClass())) continue;
            return this.convertObjectToOutput(converter.convert(value));
        }
        return value.toString();
    }

    private Map<Object, Object> convertMapToOutput(Map<?, ?> attributes) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : attributes.entrySet()) {
            result.put(this.convertObjectToOutput(entry.getKey()), this.convertObjectToOutput(entry.getValue()));
        }
        return result;
    }

    private Collection<?> convertCollectionToOutput(Collection<?> value) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object entry : value) {
            result.add(this.convertObjectToOutput(entry));
        }
        return result;
    }
}

