/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import org.apache.pdfbox.io.RandomAccessRead;

public class RandomAccessReadView
implements RandomAccessRead {
    private RandomAccessRead randomAccessRead;
    private final long startPosition;
    private final long streamLength;
    private final boolean closeInput;
    private long currentPosition = 0L;

    public RandomAccessReadView(RandomAccessRead randomAccessRead, long startPosition, long streamLength) {
        this(randomAccessRead, startPosition, streamLength, false);
    }

    public RandomAccessReadView(RandomAccessRead randomAccessRead, long startPosition, long streamLength, boolean closeInput) {
        this.randomAccessRead = randomAccessRead;
        this.startPosition = startPosition;
        this.streamLength = streamLength;
        this.closeInput = closeInput;
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.currentPosition;
    }

    @Override
    public void seek(long newOffset) throws IOException {
        this.checkClosed();
        if (newOffset < 0L) {
            throw new IOException("Invalid position " + newOffset);
        }
        this.randomAccessRead.seek(this.startPosition + Math.min(newOffset, this.streamLength));
        this.currentPosition = newOffset;
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        this.restorePosition();
        int readValue = this.randomAccessRead.read();
        if (readValue > -1) {
            ++this.currentPosition;
        }
        return readValue;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        this.restorePosition();
        int readBytes = this.randomAccessRead.read(b, off, Math.min(len, this.available()));
        this.currentPosition += (long)readBytes;
        return readBytes;
    }

    @Override
    public long length() throws IOException {
        this.checkClosed();
        return this.streamLength;
    }

    @Override
    public void close() throws IOException {
        if (this.closeInput && this.randomAccessRead != null) {
            this.randomAccessRead.close();
        }
        this.randomAccessRead = null;
    }

    @Override
    public boolean isClosed() {
        return this.randomAccessRead == null || this.randomAccessRead.isClosed();
    }

    @Override
    public void rewind(int bytes) throws IOException {
        this.checkClosed();
        this.restorePosition();
        this.randomAccessRead.rewind(bytes);
        this.currentPosition -= (long)bytes;
    }

    @Override
    public boolean isEOF() throws IOException {
        this.checkClosed();
        return this.currentPosition >= this.streamLength;
    }

    private void restorePosition() throws IOException {
        this.randomAccessRead.seek(this.startPosition + this.currentPosition);
    }

    private void checkClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("RandomAccessReadView already closed");
        }
    }

    @Override
    public RandomAccessReadView createView(long startPosition, long streamLength) throws IOException {
        throw new IOException(this.getClass().getName() + ".createView isn't supported.");
    }
}

