/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.file.Folder;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.watch.IModifiable;

public class File
extends java.io.File
implements IModifiable {
    private static final long serialVersionUID = 1L;

    public File(File parent, String child) {
        super(parent, child);
    }

    public File(java.io.File parent, String child) {
        super(parent, child);
    }

    public File(java.io.File file) {
        super(file.getAbsolutePath());
    }

    public File(String pathname) {
        super(pathname);
    }

    public File(String parent, String child) {
        super(parent, child);
    }

    public File(URI uri) {
        super(uri);
    }

    public File file(String name) {
        return new File(this, name);
    }

    public String getExtension() {
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot >= 0) {
            return this.getName().substring(lastDot + 1);
        }
        return null;
    }

    public Folder getParentFolder() {
        return new Folder(this.getParent());
    }

    public InputStream inputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this));
    }

    @Override
    public Instant lastModifiedTime() {
        long time = this.lastModified();
        if (time == 0L) {
            return null;
        }
        return Instant.ofEpochMilli(time);
    }

    public OutputStream outputStream() throws FileNotFoundException {
        Folder parent = this.getParentFolder();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new FileNotFoundException("Couldn't create path " + String.valueOf(parent));
        }
        return new BufferedOutputStream(new FileOutputStream(this));
    }

    public String readString() throws IOException {
        try (FileInputStream in = new FileInputStream(this);){
            String string = Streams.readString(in);
            return string;
        }
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return new ObjectInputStream(this.inputStream()).readObject();
    }

    public void writeObject(Serializable object) throws IOException {
        new ObjectOutputStream(this.outputStream()).writeObject(object);
    }

    public boolean remove() {
        return Files.remove(this);
    }

    public void sync() throws IOException {
        try (FileInputStream in = new FileInputStream(this);){
            in.getFD().sync();
        }
    }

    public String toQuotedString() {
        return "\"" + this.toString() + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int n = this.write(in);
            return n;
        }
    }

    public int write(InputStream input) throws IOException {
        return Files.writeTo(this, input);
    }

    public void write(String string) throws IOException {
        try (FileWriter out = new FileWriter(this);){
            out.write(string);
        }
    }
}

