/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.discovery.zen.ElectMasterService;
import org.opensearch.gateway.ClusterStateUpdaters;
import org.opensearch.gateway.GatewayException;
import org.opensearch.gateway.TransportNodesListGatewayMetaState;
import org.opensearch.index.Index;

public class Gateway {
    private static final Logger logger = LogManager.getLogger(Gateway.class);
    private final ClusterService clusterService;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;
    private final int minimumMasterNodes;

    public Gateway(Settings settings, ClusterService clusterService, TransportNodesListGatewayMetaState listGatewayMetaState) {
        this.clusterService = clusterService;
        this.listGatewayMetaState = listGatewayMetaState;
        this.minimumMasterNodes = ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.get(settings);
    }

    public void performStateRecovery(GatewayStateRecoveredListener listener) throws GatewayException {
        Object[] nodesIds = (String[])this.clusterService.state().nodes().getMasterNodes().keys().toArray(String.class);
        logger.trace("performing state recovery from {}", (Object)Arrays.toString(nodesIds));
        TransportNodesListGatewayMetaState.NodesGatewayMetaState nodesState = this.listGatewayMetaState.list((String[])nodesIds, null).actionGet();
        int requiredAllocation = Math.max(1, this.minimumMasterNodes);
        if (nodesState.hasFailures()) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                logger.warn("failed to fetch state from node", (Throwable)failedNodeException);
            }
        }
        ObjectFloatHashMap indices = new ObjectFloatHashMap();
        Metadata electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
            if (nodeState.metadata() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metadata();
            } else if (nodeState.metadata().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metadata();
            }
            for (ObjectCursor cursor : nodeState.metadata().indices().values()) {
                indices.addTo((Object)((IndexMetadata)cursor.value).getIndex(), 1.0f);
            }
        }
        if (found < requiredAllocation) {
            listener.onFailure("found [" + found + "] metadata states, required [" + requiredAllocation + "]");
            return;
        }
        Metadata.Builder metadataBuilder = Metadata.builder(electedGlobalState).removeAllIndices();
        assert (!indices.containsKey(null));
        Object[] keys = indices.keys;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            Index index = (Index)keys[i];
            IndexMetadata electedIndexMetadata = null;
            int indexMetadataCount = 0;
            for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
                IndexMetadata indexMetadata;
                if (nodeState.metadata() == null || (indexMetadata = nodeState.metadata().index(index)) == null) continue;
                if (electedIndexMetadata == null) {
                    electedIndexMetadata = indexMetadata;
                } else if (indexMetadata.getVersion() > electedIndexMetadata.getVersion()) {
                    electedIndexMetadata = indexMetadata;
                }
                ++indexMetadataCount;
            }
            if (electedIndexMetadata == null) continue;
            if (indexMetadataCount < requiredAllocation) {
                logger.debug("[{}] found [{}], required [{}], not adding", (Object)index, (Object)indexMetadataCount, (Object)requiredAllocation);
            }
            metadataBuilder.put(electedIndexMetadata, false);
        }
        ClusterState recoveredState = Function.identity().andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, this.clusterService.getClusterSettings())).apply(ClusterState.builder(this.clusterService.getClusterName()).metadata(metadataBuilder).build());
        listener.onSuccess(recoveredState);
    }

    public static interface GatewayStateRecoveredListener {
        public void onSuccess(ClusterState var1);

        public void onFailure(String var1);
    }
}

