/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.search.suggest.phrase.Correction;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.WordScorer;

final class CandidateScorer {
    private final WordScorer scorer;
    private final int maxNumCorrections;
    private final int gramSize;

    CandidateScorer(WordScorer scorer, int maxNumCorrections, int gramSize) {
        this.scorer = scorer;
        this.maxNumCorrections = maxNumCorrections;
        this.gramSize = gramSize;
    }

    public Correction[] findBestCandiates(DirectCandidateGenerator.CandidateSet[] sets, float errorFraction, double cutoffScore) throws IOException {
        if (sets.length == 0) {
            return Correction.EMPTY;
        }
        PriorityQueue<Correction> corrections = new PriorityQueue<Correction>(this.maxNumCorrections){

            protected boolean lessThan(Correction a, Correction b) {
                return a.compareTo(b) < 0;
            }
        };
        int numMissspellings = 1;
        numMissspellings = (double)errorFraction >= 1.0 ? (int)errorFraction : Math.round(errorFraction * (float)sets.length);
        this.findCandidates(sets, new DirectCandidateGenerator.Candidate[sets.length], 0, Math.max(1, numMissspellings), corrections, cutoffScore, 0.0);
        Correction[] result = new Correction[corrections.size()];
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (Correction)corrections.pop();
        }
        assert (corrections.size() == 0);
        return result;
    }

    public void findCandidates(DirectCandidateGenerator.CandidateSet[] candidates, DirectCandidateGenerator.Candidate[] path, int ord, int numMissspellingsLeft, PriorityQueue<Correction> corrections, double cutoffScore, double pathScore) throws IOException {
        DirectCandidateGenerator.CandidateSet current = candidates[ord];
        if (ord == candidates.length - 1) {
            path[ord] = current.originalTerm;
            this.updateTop(candidates, path, corrections, cutoffScore, pathScore + this.scorer.score(path, candidates, ord, this.gramSize));
            if (numMissspellingsLeft > 0) {
                for (int i = 0; i < current.candidates.length; ++i) {
                    path[ord] = current.candidates[i];
                    this.updateTop(candidates, path, corrections, cutoffScore, pathScore + this.scorer.score(path, candidates, ord, this.gramSize));
                }
            }
        } else if (numMissspellingsLeft > 0) {
            path[ord] = current.originalTerm;
            this.findCandidates(candidates, path, ord + 1, numMissspellingsLeft, corrections, cutoffScore, pathScore + this.scorer.score(path, candidates, ord, this.gramSize));
            for (int i = 0; i < current.candidates.length; ++i) {
                path[ord] = current.candidates[i];
                this.findCandidates(candidates, path, ord + 1, numMissspellingsLeft - 1, corrections, cutoffScore, pathScore + this.scorer.score(path, candidates, ord, this.gramSize));
            }
        } else {
            path[ord] = current.originalTerm;
            this.findCandidates(candidates, path, ord + 1, 0, corrections, cutoffScore, pathScore + this.scorer.score(path, candidates, ord, this.gramSize));
        }
    }

    private void updateTop(DirectCandidateGenerator.CandidateSet[] candidates, DirectCandidateGenerator.Candidate[] path, PriorityQueue<Correction> corrections, double cutoffScore, double score) throws IOException {
        score = Math.exp(score);
        assert (Math.abs(score - this.score(path, candidates)) < 1.0E-5) : "cur_score=" + score + ", path_score=" + this.score(path, candidates);
        if (score > cutoffScore) {
            if (corrections.size() < this.maxNumCorrections) {
                DirectCandidateGenerator.Candidate[] c = new DirectCandidateGenerator.Candidate[candidates.length];
                System.arraycopy(path, 0, c, 0, path.length);
                corrections.add((Object)new Correction(score, c));
            } else if (((Correction)corrections.top()).compareTo(score, path) < 0) {
                Correction top = (Correction)corrections.top();
                System.arraycopy(path, 0, top.candidates, 0, path.length);
                top.score = score;
                corrections.updateTop();
            }
        }
    }

    public double score(DirectCandidateGenerator.Candidate[] path, DirectCandidateGenerator.CandidateSet[] candidates) throws IOException {
        double score = 0.0;
        for (int i = 0; i < candidates.length; ++i) {
            score += this.scorer.score(path, candidates, i, this.gramSize);
        }
        return Math.exp(score);
    }
}

