/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;

public interface ConfigurableUserGroupProvider
extends UserGroupProvider {
    public String getFingerprint() throws AuthorizationAccessException;

    public void inheritFingerprint(String var1) throws AuthorizationAccessException;

    public void checkInheritability(String var1) throws AuthorizationAccessException, UninheritableAuthorizationsException;

    public User addUser(User var1) throws AuthorizationAccessException;

    default public boolean isConfigurable(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        return this.getUser(user.getIdentifier()) != null;
    }

    public User updateUser(User var1) throws AuthorizationAccessException;

    public User deleteUser(User var1) throws AuthorizationAccessException;

    public Group addGroup(Group var1) throws AuthorizationAccessException;

    default public boolean isConfigurable(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        return this.getGroup(group.getIdentifier()) != null;
    }

    public Group updateGroup(Group var1) throws AuthorizationAccessException;

    public Group deleteGroup(Group var1) throws AuthorizationAccessException;
}

