/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.endpoints.internal.Arn;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;

@SdkInternalApi
public final class StsAuthUtils {
    private StsAuthUtils() {
    }

    public static String accountIdFromArn(AssumedRoleUser assumedRoleUser) {
        if (assumedRoleUser == null) {
            return null;
        }
        return Arn.parse(assumedRoleUser.arn()).map(Arn::accountId).orElse(null);
    }

    public static AwsSessionCredentials fromStsCredentials(Credentials credentials, String provider) {
        return StsAuthUtils.fromStsCredentials(credentials, provider, null);
    }

    public static AwsSessionCredentials fromStsCredentials(Credentials credentials, String provider, String accountId) {
        return AwsSessionCredentials.builder().accessKeyId(credentials.accessKeyId()).secretAccessKey(credentials.secretAccessKey()).sessionToken(credentials.sessionToken()).expirationTime(credentials.expiration()).providerName(provider).accountId(accountId).build();
    }
}

