/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointParams;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import software.amazon.awssdk.services.sts.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.sts.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.sts.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultStsEndpointProvider
implements StsEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(StsEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useGlobalEndpoint(), (String)"Parameter 'UseGlobalEndpoint' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultStsEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(StsEndpointParams params, String region) {
        RuleResult result = DefaultStsEndpointProvider.endpointRule1(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultStsEndpointProvider.endpointRule19(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultStsEndpointProvider.endpointRule23(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(StsEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.useGlobalEndpoint().booleanValue() && params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            if ("ap-northeast-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("ap-south-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("ap-southeast-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("ap-southeast-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("ca-central-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("eu-central-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("eu-north-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("eu-west-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("eu-west-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("eu-west-3".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("sa-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("us-east-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("us-west-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            if ("us-west-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(StsEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(StsEndpointParams params, String region) {
        if (region != null) {
            return DefaultStsEndpointProvider.endpointRule24(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(StsEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule25(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultStsEndpointProvider.endpointRule29(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultStsEndpointProvider.endpointRule34(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            if ("aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(StsEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule26(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(StsEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(StsEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule30(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(StsEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            if ("aws-us-gov".equals(partitionResult.name())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + region + ".amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule34(StsEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule35(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule35(StsEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

