/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.net.InetAddressRange;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    private List<NamedFactory<Signature>> factories;

    public UserAuthPublicKey() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthPublicKey(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        boolean authed;
        PublicKey key;
        ValidateUtils.checkTrue((boolean)init, (String)"Instance not initialized");
        ServerSession session = this.getServerSession();
        String username = this.getUsername();
        boolean hasSig = buffer.getBoolean();
        String alg = buffer.getString();
        int oldLim = buffer.wpos();
        int oldPos = buffer.rpos();
        int len = buffer.getInt();
        int remaining = buffer.available();
        if (len < 0 || len > remaining) {
            this.log.error("doAuth({}@{}) illogical algorithm={} signature length ({}) when remaining={}", new Object[]{username, session, alg, len, remaining});
            throw new IndexOutOfBoundsException("Illogical signature length (" + len + ") for algorithm=" + alg);
        }
        buffer.wpos(buffer.rpos() + len);
        PublicKey verifyKey = key = buffer.getRawPublicKey();
        if (key instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)key;
            try {
                if (!OpenSshCertificate.Type.USER.equals((Object)cert.getType())) {
                    throw new CertificateException("not a user certificate");
                }
                if (!OpenSshCertificate.isValidNow((OpenSshCertificate)cert)) {
                    throw new CertificateException("expired");
                }
                this.verifyCertificateSignature(session, cert);
                this.verifyCertificateSources(session, cert);
            }
            catch (Exception e) {
                this.warn("doAuth({}@{}): public key certificate (id={}) is not valid: {}", username, session, cert.getId(), e.getMessage(), e);
                return Boolean.FALSE;
            }
            verifyKey = cert.getCertPubKey();
        }
        Collection factories = ValidateUtils.checkNotNullAndNotEmpty((Collection)SignatureFactoriesManager.resolveSignatureFactories((SignatureFactoriesManager)this, (SignatureFactoriesManager)session), (String)"No signature factories for session=%s", (Object[])new Object[]{session});
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) verify key type={}, factories={}, fingerprint={}", new Object[]{username, session, alg, NamedResource.getNames((Collection)factories), KeyUtils.getFingerPrint((PublicKey)key)});
        }
        Signature verifier = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create((Collection)factories, (String)alg)), (String)"No verifier located for algorithm=%s", (Object)alg);
        verifier.initVerifier((SessionContext)session, verifyKey);
        buffer.wpos(oldLim);
        byte[] sig = hasSig ? buffer.getBytes() : null;
        PublickeyAuthenticator authenticator = session.getPublickeyAuthenticator();
        if (authenticator == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - no authenticator", new Object[]{username, session, alg, KeyUtils.getFingerPrint((PublicKey)key)});
            }
            return Boolean.FALSE;
        }
        try {
            authed = authenticator.authenticate(username, key, session);
        }
        catch (Error e) {
            this.warn("doAuth({}@{}) failed ({}) to consult delegate for {} key={}: {}", username, session, e.getClass().getSimpleName(), alg, KeyUtils.getFingerPrint((PublicKey)key), e.getMessage(), e);
            throw new RuntimeSshException((Throwable)e);
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - authentication result: {}", new Object[]{username, session, alg, KeyUtils.getFingerPrint((PublicKey)key), authed});
        }
        if (!authed) {
            return Boolean.FALSE;
        }
        if (!hasSig) {
            this.sendPublicKeyResponse(session, username, alg, key, buffer.array(), oldPos, 4 + len, buffer);
            return null;
        }
        buffer.rpos(oldPos);
        buffer.wpos(oldPos + 4 + len);
        if (!this.verifySignature(session, username, alg, key, buffer, verifier, sig)) {
            throw new SignatureException("Key verification failed");
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - verified", new Object[]{username, session, alg, KeyUtils.getFingerPrint((PublicKey)key)});
        }
        return Boolean.TRUE;
    }

    protected void verifyCertificateSignature(ServerSession session, OpenSshCertificate cert) throws Exception {
        PublicKey signatureKey = cert.getCaPubKey();
        String keyAlg = KeyUtils.getKeyType((Key)signatureKey);
        String keyId = cert.getId();
        String sigAlg = cert.getSignatureAlgorithm();
        if (!keyAlg.equals(KeyUtils.getCanonicalKeyType((String)sigAlg))) {
            throw new CertificateException("Found invalid signature alg " + sigAlg + " for key ID=" + keyId + " using a " + keyAlg + " CA key");
        }
        Signature verif = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create((Collection)session.getSignatureFactories(), (String)sigAlg)), (String)"No CA verifier located for algorithm=%s of key ID=%s", (Object[])new Object[]{sigAlg, keyId});
        verif.initVerifier((SessionContext)session, signatureKey);
        verif.update((SessionContext)session, cert.getMessage());
        if (!verif.verify((SessionContext)session, cert.getSignature())) {
            throw new CertificateException("CA signature verification failed for key type=" + keyAlg + " of key ID=" + keyId);
        }
    }

    protected void verifyCertificateSources(ServerSession session, OpenSshCertificate cert) throws CertificateException {
        String allowedSources = (String)cert.getCriticalOptionsMap().get("source-address");
        if (allowedSources == null) {
            return;
        }
        SocketAddress remote = session.getRemoteAddress();
        if (remote instanceof InetSocketAddress) {
            InetAddress remoteAddress = ((InetSocketAddress)remote).getAddress();
            for (String allowed : allowedSources.split(",")) {
                String cidr = allowed.trim();
                if (GenericUtils.isEmpty((CharSequence)cidr)) continue;
                try {
                    if (!InetAddressRange.fromCIDR((String)cidr).contains(remoteAddress)) continue;
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw new CertificateException("Invalid CIDR range '" + cidr + "' in source-address critical option");
                }
            }
            throw new CertificateException("Rejected by source-address critical option; not allowed from " + remoteAddress);
        }
    }

    protected boolean verifySignature(ServerSession session, String username, String alg, PublicKey key, Buffer buffer, Signature verifier, byte[] sig) throws Exception {
        byte[] id = session.getSessionId();
        String service = this.getService();
        String name = this.getName();
        ByteArrayBuffer buf = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + alg.length() + 256 + 64, false);
        buf.putBytes(id);
        buf.putByte((byte)50);
        buf.putString(username);
        buf.putString(service);
        buf.putString(name);
        buf.putBoolean(true);
        buf.putString(alg);
        buf.putBuffer((Readable)buffer);
        if (this.log.isTraceEnabled()) {
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - verification data={}", new Object[]{username, session, service, name, alg, KeyUtils.getFingerPrint((PublicKey)key), buf.toHex()});
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - expected signature={}", new Object[]{username, session, service, name, alg, KeyUtils.getFingerPrint((PublicKey)key), BufferUtils.toHex((byte[])sig)});
        }
        verifier.update((SessionContext)session, buf.array(), buf.rpos(), buf.available());
        return verifier.verify((SessionContext)session, sig);
    }

    protected void sendPublicKeyResponse(ServerSession session, String username, String alg, PublicKey key, byte[] keyBlob, int offset, int blobLen, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) send SSH_MSG_USERAUTH_PK_OK for key type={}, fingerprint={}", new Object[]{username, session, alg, KeyUtils.getFingerPrint((PublicKey)key)});
        }
        Buffer buf = session.createBuffer((byte)60, GenericUtils.length((CharSequence)alg) + blobLen + 32);
        buf.putString(alg);
        buf.putRawBytes(keyBlob, offset, blobLen);
        session.writePacket(buf);
    }
}

