/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class ClassLoadableResourceKeyPairProvider
extends AbstractResourceKeyPairProvider<String> {
    private ClassLoader classLoader;
    private Collection<String> resources;

    public ClassLoadableResourceKeyPairProvider() {
        this(Collections.emptyList());
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader cl) {
        this(cl, Collections.emptyList());
    }

    public ClassLoadableResourceKeyPairProvider(String res) {
        this(Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(res, "No resource specified")));
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader cl, String res) {
        this(cl, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(res, "No resource specified")));
    }

    public ClassLoadableResourceKeyPairProvider(Collection<String> resources) {
        this.classLoader = ThreadUtils.resolveDefaultClassLoader(this.getClass());
        this.resources = resources == null ? Collections.emptyList() : resources;
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader cl, Collection<String> resources) {
        this.classLoader = cl;
        this.resources = resources == null ? Collections.emptyList() : resources;
    }

    public Collection<String> getResources() {
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        this.resources = resources == null ? Collections.emptyList() : resources;
    }

    public ClassLoader getResourceLoader() {
        return this.classLoader;
    }

    public void setResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        return this.loadKeys(this.getResources());
    }

    @Override
    protected InputStream openKeyPairResource(String resourceKey, String resource) throws IOException {
        ClassLoader cl = this.resolveClassLoader();
        if (cl == null) {
            throw new StreamCorruptedException("No resource loader for " + resource);
        }
        InputStream input = cl.getResourceAsStream(resource);
        if (input == null) {
            throw new FileNotFoundException("Cannot find resource " + resource);
        }
        return input;
    }

    protected ClassLoader resolveClassLoader() {
        ClassLoader cl = this.getResourceLoader();
        if (cl == null) {
            cl = ThreadUtils.resolveDefaultClassLoader(this.getClass());
        }
        return cl;
    }
}

